/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class InputStreamTest
extends SimpleTest {
    private static final byte[] outOfBoundsLength = new byte[]{48, -1, -1, -1, -1, -1};
    private static final byte[] negativeLength = new byte[]{48, -124, -1, -1, -1, -1};
    private static final byte[] outsideLimitLength = new byte[]{48, -125, 15, -1, -1};
    private static final byte[] classCast1 = Base64.decode((String)"p1AkHmYAvfOEIrL4ESfrNg==");
    private static final byte[] classCast2 = Base64.decode((String)"JICNbaBUTTq7uxj5mg==");
    private static final byte[] classCast3 = Base64.decode((String)"JAKzADNCxhrrBSVS");
    private static final byte[] memoryError1 = Base64.decode((String)"vm66gOiEe+FV/NvujMwSkUp5Lffw5caQlaRU5sdMPC70IGWmyK2/");
    private static final byte[] memoryError2 = Base64.decode((String)"vm4ogOSEfVGsS3w+KTzb2A0ALYR8VBOQqQeuRwnsPC4AAGWEDLjd");

    public String getName() {
        return "InputStream";
    }

    public void performTest() throws Exception {
        block8: {
            ASN1InputStream aIn;
            block7: {
                block6: {
                    aIn = new ASN1InputStream(outOfBoundsLength);
                    try {
                        aIn.readObject();
                        this.fail("out of bounds length not detected.");
                    }
                    catch (IOException e) {
                        if (e.getMessage().startsWith("invalid long form definite-length 0xFF")) break block6;
                        this.fail("wrong exception: " + e.getMessage());
                    }
                }
                aIn = new ASN1InputStream(negativeLength);
                try {
                    aIn.readObject();
                    this.fail("negative length not detected.");
                }
                catch (IOException e) {
                    if (e.getMessage().equals("long form definite-length more than 31 bits")) break block7;
                    this.fail("wrong exception: " + e.getMessage());
                }
            }
            aIn = new ASN1InputStream(outsideLimitLength);
            try {
                aIn.readObject();
                this.fail("outside limit length not detected.");
            }
            catch (IOException e) {
                if (e.getMessage().equals("corrupted stream - out of bounds length found: 1048575 >= 5")) break block8;
                this.fail("wrong exception: " + e.getMessage());
            }
        }
        this.testWithByteArray(classCast2, "unknown object encountered: class org.bouncycastle.asn1.DLTaggedObjectParser");
        this.testWithByteArray(classCast3, "unknown object encountered in constructed OCTET STRING: class org.bouncycastle.asn1.DLTaggedObject");
    }

    /*
     * WARNING - void declaration
     */
    private void testWithByteArray(byte[] data, String message) {
        try {
            ASN1Primitive p;
            ASN1InputStream input = new ASN1InputStream(data);
            while ((p = input.readObject()) != null) {
                void var4_5;
                ASN1Sequence asn1 = ASN1Sequence.getInstance((Object)var4_5);
                int i = 0;
                while (i < asn1.size()) {
                    asn1.getObjectAt(i);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.isEquals(e.getMessage(), message, e.getMessage());
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new InputStreamTest());
    }
}

