/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.internal.asn1.oiw.ElGamalParameter;
import org.bouncycastle.internal.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class GenerationTest
extends SimpleTest {
    private byte[] v1Cert = Base64.decode((String)"MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v3Cert = Base64.decode((String)"MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");
    private byte[] v3CertNullSubject = Base64.decode((String)"MIHGoAMCAQICAQIwDQYJKoZIhvcNAQEEBQAwJTELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUwHhcNNzAwMTAxMDAwMDAxWhcNNzAwMTAxMDAwMDAyWjAAMBgwEAYGKw4HAgEBMAYCAQECAQIDBAACAQOjSjBIMEYGA1UdEQEB/wQ8MDqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAy");
    private byte[] v2CertList = Base64.decode((String)"MIIBQwIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAiMCACAQEXDTcwMDEwMTAwMDAwMVowDDAKBgNVHRUEAwoBCqCBxTCBwjBhBgNVHSMBAf8EVzBVgBQ2T3aRz8you6PBCaJJEFNrqgh0UaE6pDgwNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMoIBAjBDBgNVHRIEPDA6pDgwNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMzAKBgNVHRQEAwIBATAMBgNVHRwBAf8EAjAA");

    private void tbsV1CertGen() throws IOException {
        ASN1Primitive o;
        V1TBSCertificateGenerator gen = new V1TBSCertificateGenerator();
        Date startDate = new Date(1000L);
        Date endDate = new Date(12000L);
        gen.setSerialNumber(new ASN1Integer(1L));
        gen.setStartDate(new Time(startDate));
        gen.setEndDate(new Time(endDate));
        gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        gen.setSubject(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPublicKey(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
        gen.setSubjectPublicKeyInfo(info);
        TBSCertificate tbs = gen.generateTBSCertificate();
        byte[] encoding = tbs.getEncoded();
        if (!Arrays.areEqual((byte[])encoding, (byte[])this.v1Cert)) {
            this.fail("failed v1 cert generation");
        }
        if (!Arrays.areEqual((byte[])(encoding = (o = ASN1Primitive.fromByteArray((byte[])this.v1Cert)).getEncoded()), (byte[])this.v1Cert)) {
            this.fail("failed v1 cert read back test");
        }
    }

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo info, X500Name name, int sNumber) {
        GeneralName genName = new GeneralName(name);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)genName);
        return new AuthorityKeyIdentifier(GenerationTest.getDigest(info), GeneralNames.getInstance((Object)new DERSequence(v)), BigInteger.valueOf(sNumber));
    }

    private void tbsV3CertGen() throws IOException {
        ASN1Primitive o;
        V3TBSCertificateGenerator gen = new V3TBSCertificateGenerator();
        Date startDate = new Date(1000L);
        Date endDate = new Date(2000L);
        gen.setSerialNumber(new ASN1Integer(2L));
        gen.setStartDate(new Time(startDate));
        gen.setEndDate(new Time(endDate));
        gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        gen.setSubject(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, (ASN1Encodable)new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), (ASN1Encodable)new ASN1Integer(3L));
        gen.setSubjectPublicKeyInfo(info);
        Extensions ex = new Extensions(new Extension[]{new Extension(Extension.authorityKeyIdentifier, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)this.createAuthorityKeyId(info, new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))), new Extension(Extension.subjectKeyIdentifier, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)new SubjectKeyIdentifier(GenerationTest.getDigest(info)))), new Extension(Extension.keyUsage, false, (ASN1OctetString)new DEROctetString((ASN1Encodable)new KeyUsage(16)))});
        gen.setExtensions(ex);
        TBSCertificate tbs = gen.generateTBSCertificate();
        byte[] encoding = tbs.getEncoded();
        if (!Arrays.areEqual((byte[])encoding, (byte[])this.v3Cert)) {
            this.fail("failed v3 cert generation");
        }
        if (!Arrays.areEqual((byte[])(encoding = (o = ASN1Primitive.fromByteArray((byte[])this.v3Cert)).getEncoded()), (byte[])this.v3Cert)) {
            this.fail("failed v3 cert read back test");
        }
    }

    private void tbsV3CertGenWithNullSubject() throws IOException {
        ASN1Primitive o;
        V3TBSCertificateGenerator gen;
        block4: {
            gen = new V3TBSCertificateGenerator();
            Date startDate = new Date(1000L);
            Date endDate = new Date(2000L);
            gen.setSerialNumber(new ASN1Integer(2L));
            gen.setStartDate(new Time(startDate));
            gen.setEndDate(new Time(endDate));
            gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
            gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, (ASN1Encodable)new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), (ASN1Encodable)new ASN1Integer(3L));
            gen.setSubjectPublicKeyInfo(info);
            try {
                gen.generateTBSCertificate();
                this.fail("null subject not caught!");
            }
            catch (IllegalStateException e) {
                if (e.getMessage().equals("not all mandatory fields set in V3 TBScertificate generator")) break block4;
                this.fail("unexpected exception", e);
            }
        }
        Extensions ex = new Extensions(new Extension(Extension.subjectAlternativeName, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)new GeneralNames(new GeneralName(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"))))));
        gen.setExtensions(ex);
        TBSCertificate tbs = gen.generateTBSCertificate();
        byte[] encoding = tbs.getEncoded();
        if (!Arrays.areEqual((byte[])encoding, (byte[])this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert generation");
        }
        if (!Arrays.areEqual((byte[])(encoding = (o = ASN1Primitive.fromByteArray((byte[])this.v3CertNullSubject)).getEncoded()), (byte[])this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert read back test");
        }
    }

    private void tbsV2CertListGen() throws IOException {
        V2TBSCertListGenerator gen = new V2TBSCertListGenerator();
        gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        gen.addCRLEntry(new ASN1Integer(1L), new Time(new Date(1000L)), 10);
        gen.setNextUpdate(new Time(new Date(2000L)));
        gen.setThisUpdate(new Time(new Date(500L)));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, (ASN1Encodable)new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), (ASN1Encodable)new ASN1Integer(3L));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.authorityKeyIdentifier, true, (ASN1Encodable)this.createAuthorityKeyId(info, new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2));
        extGen.addExtension(Extension.issuerAlternativeName, false, (ASN1Encodable)new GeneralNames(new GeneralName(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 3"))));
        extGen.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new ASN1Integer(1L));
        extGen.addExtension(Extension.issuingDistributionPoint, true, (ASN1Encodable)IssuingDistributionPoint.getInstance((Object)new DERSequence()));
        this.isTrue(extGen.hasExtension(Extension.cRLNumber));
        this.isTrue(!extGen.hasExtension(Extension.freshestCRL));
        this.isEquals(new Extension(Extension.cRLNumber, false, new ASN1Integer(1L).getEncoded()), extGen.getExtension(Extension.cRLNumber));
        Extensions ex = extGen.generate();
        gen.setExtensions(ex);
        TBSCertList tbs = gen.generateTBSCertList();
        byte[] encoding = tbs.getEncoded();
        if (!Arrays.areEqual((byte[])encoding, (byte[])this.v2CertList)) {
            System.out.println(new String(Base64.encode((byte[])encoding)));
            this.fail("failed v2 cert list generation");
        }
        extGen.replaceExtension(Extension.cRLNumber, false, (ASN1Encodable)new ASN1Integer(2L));
        this.isEquals(new Extension(Extension.cRLNumber, false, new ASN1Integer(2L).getEncoded()), extGen.getExtension(Extension.cRLNumber));
        extGen.removeExtension(Extension.cRLNumber);
        this.isTrue(!extGen.hasExtension(Extension.cRLNumber));
        ex = extGen.generate();
        ASN1Primitive o = ASN1Primitive.fromByteArray((byte[])this.v2CertList);
        encoding = o.getEncoded();
        if (!Arrays.areEqual((byte[])encoding, (byte[])this.v2CertList)) {
            this.fail("failed v2 cert list read back test");
        }
        gen.addCRLEntry(new ASN1Integer(1L), new Time(new Date(1000L)), 10);
        gen.addCRLEntry(new ASN1Integer(2L), new Time(new Date(1000L)), 3, new ASN1GeneralizedTime(new Date(2000L)));
        TBSCertList crl = gen.generateTBSCertList();
        TBSCertList.CRLEntry[] entries = crl.getRevokedCertificates();
        int i = 0;
        while (i != entries.length) {
            CRLReason r;
            Extension ext;
            Extensions extensions;
            TBSCertList.CRLEntry entry = entries[i];
            if (entry.getUserCertificate().equals((ASN1Primitive)new ASN1Integer(1L))) {
                extensions = entry.getExtensions();
                ext = extensions.getExtension(Extension.reasonCode);
                r = CRLReason.getInstance((Object)ext.getParsedValue());
                if (r.getValue().intValue() != 10) {
                    this.fail("reason code mismatch");
                }
            } else if (entry.getUserCertificate().equals((ASN1Primitive)new ASN1Integer(2L))) {
                extensions = entry.getExtensions();
                ext = extensions.getExtension(Extension.reasonCode);
                r = CRLReason.getInstance((Object)ext.getParsedValue());
                if (r.getValue().intValue() != 3) {
                    this.fail("reason code mismatch");
                }
                ext = extensions.getExtension(Extension.invalidityDate);
                ASN1GeneralizedTime t = ASN1GeneralizedTime.getInstance((Object)ext.getParsedValue());
                try {
                    if (!t.getDate().equals(new Date(2000L))) {
                        this.fail("invalidity date mismatch");
                    }
                }
                catch (ParseException e) {
                    this.fail("can't parse date", e);
                }
            }
            ++i;
        }
    }

    public void testDuplicateExtensions() throws IOException {
        GeneralName name1 = new GeneralName(2, "bc1.local");
        GeneralName name2 = new GeneralName(2, "bc2.local");
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name1));
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name2));
        Extensions ext = Extensions.getInstance((Object)ASN1Sequence.getInstance((Object)extensionsGenerator.generate().getEncoded()));
        Extension returnedExtension = ext.getExtension(Extension.subjectAlternativeName);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)returnedExtension.getParsedValue());
        if (!GeneralName.getInstance((Object)seq.getObjectAt(0)).equals((Object)name1)) {
            this.fail("expected name 1");
        }
        if (!GeneralName.getInstance((Object)seq.getObjectAt(1)).equals((Object)name2)) {
            this.fail("expected name 2");
        }
        ExtensionsGenerator genX = new ExtensionsGenerator();
        genX.addExtension(ext);
        ext = Extensions.getInstance((Object)ASN1Sequence.getInstance((Object)genX.generate().getEncoded()));
        returnedExtension = ext.getExtension(Extension.subjectAlternativeName);
        seq = ASN1Sequence.getInstance((Object)returnedExtension.getParsedValue());
        if (!GeneralName.getInstance((Object)seq.getObjectAt(0)).equals((Object)name1)) {
            this.fail("expected name 1");
        }
        if (!GeneralName.getInstance((Object)seq.getObjectAt(1)).equals((Object)name2)) {
            this.fail("expected name 2");
        }
    }

    public void testAllowedDuplicateExtensions() throws Exception {
        GeneralName name1 = new GeneralName(2, "bc1.local");
        GeneralName name2 = new GeneralName(2, "bc2.local");
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name1));
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name2));
        extensionsGenerator.addExtension(Extension.issuerAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name1));
        extensionsGenerator.addExtension(Extension.issuerAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name2));
        extensionsGenerator.addExtension(Extension.subjectDirectoryAttributes, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name1));
        extensionsGenerator.addExtension(Extension.subjectDirectoryAttributes, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name2));
        extensionsGenerator.addExtension(Extension.certificateIssuer, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name1));
        extensionsGenerator.addExtension(Extension.certificateIssuer, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name2));
        extensionsGenerator.addExtension(Extension.auditIdentity, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name1));
        try {
            extensionsGenerator.addExtension(Extension.auditIdentity, false, (ASN1Encodable)new DERSequence((ASN1Encodable)name2));
            this.fail("Expected exception, not a white listed duplicate.");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void performTest() throws Exception {
        this.testAllowedDuplicateExtensions();
        this.testDuplicateExtensions();
        this.tbsV1CertGen();
        this.tbsV3CertGen();
        this.tbsV3CertGenWithNullSubject();
        this.tbsV2CertListGen();
    }

    public String getName() {
        return "Generation";
    }

    private static byte[] getDigest(SubjectPublicKeyInfo spki) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        return resBuf;
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new GenerationTest());
    }
}

