/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GeneralizedTimeTest
extends SimpleTest {
    String[] input = new String[]{"20020122122220", "20020122122220Z", "20020122122220-1000", "20020122122220+00", "20020122122220.1", "20020122122220.1Z", "20020122122220.1-1000", "20020122122220.1+00", "20020122122220.01", "20020122122220.01Z", "20020122122220.01-1000", "20020122122220.01+00", "20020122122220.001", "20020122122220.001Z", "20020122122220.001-1000", "20020122122220.001+00", "20020122122220.0001", "20020122122220.0001Z", "20020122122220.0001-1000", "20020122122220.0001+00", "20020122122220.0001+1000"};
    String[] output = new String[]{"20020122122220", "20020122122220GMT+00:00", "20020122122220GMT-10:00", "20020122122220GMT+00:00", "20020122122220.1", "20020122122220.1GMT+00:00", "20020122122220.1GMT-10:00", "20020122122220.1GMT+00:00", "20020122122220.01", "20020122122220.01GMT+00:00", "20020122122220.01GMT-10:00", "20020122122220.01GMT+00:00", "20020122122220.001", "20020122122220.001GMT+00:00", "20020122122220.001GMT-10:00", "20020122122220.001GMT+00:00", "20020122122220.0001", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT-10:00", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT+10:00"};
    String[] zOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};
    String[] mzOutput = new String[]{"20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122122220.100Z", "20020122122220.100Z", "20020122222220.100Z", "20020122122220.100Z", "20020122122220.010Z", "20020122122220.010Z", "20020122222220.010Z", "20020122122220.010Z", "20020122122220.001Z", "20020122122220.001Z", "20020122222220.001Z", "20020122122220.001Z", "20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122022220.000Z"};
    String[] derMzOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220.1Z", "20020122122220.1Z", "20020122222220.1Z", "20020122122220.1Z", "20020122122220.01Z", "20020122122220.01Z", "20020122222220.01Z", "20020122122220.01Z", "20020122122220.001Z", "20020122122220.001Z", "20020122222220.001Z", "20020122122220.001Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};
    String[] truncOutput = new String[]{"200201221222Z", "2002012212Z"};
    String[] derTruncOutput = new String[]{"20020122122200Z", "20020122120000Z"};

    public String getName() {
        return "GeneralizedTime";
    }

    public void performTest() throws Exception {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        int i = 0;
        while (i != this.input.length) {
            ASN1GeneralizedTime t = new ASN1GeneralizedTime(this.input[i]);
            if (this.output[i].indexOf(71) > 0) {
                if (!t.getTime().equals(this.output[i])) {
                    this.fail("failed GMT conversion test got " + t.getTime() + " expected " + this.output[i]);
                }
                if (!dateF.format(t.getDate()).equals(this.zOutput[i])) {
                    this.fail("failed date conversion test");
                }
            } else {
                String offset = this.calculateGMTOffset(t.getDate());
                if (!t.getTime().equals(this.output[i] + offset)) {
                    this.fail("failed conversion test got " + t.getTime() + " expected " + this.output[i] + offset);
                }
            }
            ++i;
        }
        dateF = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        int i2 = 0;
        while (i2 != this.input.length) {
            ASN1GeneralizedTime t = new ASN1GeneralizedTime(this.input[i2]);
            if (!dateF.format(t.getDate()).equals(this.mzOutput[i2])) {
                this.fail("failed long date conversion test");
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 != this.mzOutput.length) {
            DERGeneralizedTime t = new DERGeneralizedTime(this.mzOutput[i3]);
            if (!this.areEqual(t.getEncoded(), new ASN1GeneralizedTime(this.derMzOutput[i3]).getEncoded())) {
                this.fail("der encoding wrong");
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 != this.truncOutput.length) {
            DERGeneralizedTime t = new DERGeneralizedTime(this.truncOutput[i4]);
            if (!this.areEqual(t.getEncoded(), new ASN1GeneralizedTime(this.derTruncOutput[i4]).getEncoded())) {
                this.fail("trunc der encoding wrong");
            }
            ++i4;
        }
        ASN1GeneralizedTime ber = new ASN1GeneralizedTime("202208091215Z");
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"180d3230323230383039313231355a"), (byte[])ber.getEncoded("DL")));
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"180d3230323230383039313231355a"), (byte[])ber.getEncoded("BER")));
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"180f32303232303830393132313530305a"), (byte[])ber.getEncoded("DER")));
        DERGeneralizedTime der = new DERGeneralizedTime("202208091215Z");
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"180f32303232303830393132313530305a"), (byte[])der.getEncoded("DL")));
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"180f32303232303830393132313530305a"), (byte[])der.getEncoded("BER")));
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"180f32303232303830393132313530305a"), (byte[])der.getEncoded("DER")));
        ASN1GeneralizedTime time = new ASN1GeneralizedTime("20190704031318GMT+00:00");
        this.isTrue("20190704031318GMT+00:00".equals(time.getTime()));
        try {
            new DERGeneralizedTime(new byte[0]);
        }
        catch (IllegalArgumentException e) {
            this.isTrue(e.getMessage().equals("GeneralizedTime string too short"));
        }
    }

    private String calculateGMTOffset(Date date) {
        String sign = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int offset = timeZone.getRawOffset();
        if (offset < 0) {
            sign = "-";
            offset = -offset;
        }
        int hours = offset / 3600000;
        int minutes = (offset - hours * 60 * 60 * 1000) / 60000;
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(date)) {
            hours += sign.equals("+") ? 1 : -1;
        }
        return "GMT" + sign + this.convert(hours) + ":" + this.convert(minutes);
    }

    private String convert(int time) {
        if (time < 10) {
            return "0" + time;
        }
        return Integer.toString(time);
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new GeneralizedTimeTest());
    }
}

