/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GraphicString;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectDescriptor;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1RelativeOID;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVideotexString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class EqualsAndHashCodeTest
implements Test {
    public TestResult perform() {
        byte[] data = new byte[]{0, 1, 0, 1, 0, 0, 1};
        ASN1Primitive[] values = new ASN1Primitive[]{new BEROctetString(data), new BERSequence((ASN1Encodable)new DERPrintableString("hello world")), new BERSet((ASN1Encodable)new DERPrintableString("hello world")), new BERTaggedObject(0, (ASN1Encodable)new DERPrintableString("hello world")), new DERBitString(data), new DERBMPString("hello world"), ASN1Boolean.getInstance((boolean)true), ASN1Boolean.getInstance((boolean)false), new ASN1Enumerated(100), new DERGeneralizedTime("20070315173729Z"), new DERGeneralString("hello world"), new DERIA5String("hello"), new ASN1Integer(1000L), DERNull.INSTANCE, new DERNumericString("123456"), new ASN1ObjectIdentifier("1.1.1.10000.1"), new ASN1RelativeOID("3.2.0.123456"), new ASN1ObjectDescriptor((ASN1GraphicString)new DERGraphicString(Hex.decode((String)"feedface"))), new DEROctetString(data), new DERPrintableString("hello world"), new DERSequence((ASN1Encodable)new DERPrintableString("hello world")), new DERSet((ASN1Encodable)new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, (ASN1Encodable)new DERPrintableString("hello world")), new DERUniversalString(data), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world"), new DERGraphicString(Hex.decode((String)"deadbeef")), new DERVideotexString(Strings.toByteArray((String)"Hello World"))};
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = ASN1OutputStream.create((OutputStream)bOut);
            int i = 0;
            while (i != values.length) {
                aOut.writeObject(values[i]);
                ++i;
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            int i2 = 0;
            while (i2 != values.length) {
                ASN1Primitive o = aIn.readObject();
                if (!o.equals(values[i2])) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + o.getClass());
                }
                if (o.hashCode() != values[i2].hashCode()) {
                    return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + o.getClass());
                }
                ++i2;
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + e.toString(), e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] args) {
        EqualsAndHashCodeTest test = new EqualsAndHashCodeTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

