/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.encoders.Hex;

public class EnumeratedTest
extends TestCase {
    private static final byte[] MultipleSingleByteItems = Hex.decode((String)"30060a01010101ff");
    private static final byte[] MultipleDoubleByteItems = Hex.decode((String)"30080a0201010a020202");
    private static final byte[] MultipleTripleByteItems = Hex.decode((String)"300a0a0301010106032b0601");

    public void testReadingMultipleSingleByteItems() throws IOException {
        ASN1Primitive obj = ASN1Primitive.fromByteArray((byte[])MultipleSingleByteItems);
        Assert.assertTrue((String)"Null ASN.1 SEQUENCE", (boolean)(obj instanceof ASN1Sequence));
        ASN1Sequence sequence = (ASN1Sequence)obj;
        Assert.assertEquals((String)"2 items expected", (int)2, (int)sequence.size());
        ASN1Enumerated enumerated = ASN1Enumerated.getInstance((Object)sequence.getObjectAt(0));
        Assert.assertNotNull((String)"ENUMERATED expected", (Object)enumerated);
        Assert.assertEquals((String)"Unexpected ENUMERATED value", (int)1, (int)enumerated.intValueExact());
        Assert.assertTrue((String)"Unexpected ENUMERATED value", (boolean)enumerated.hasValue(1));
        ASN1Boolean b = ASN1Boolean.getInstance((Object)sequence.getObjectAt(1));
        Assert.assertNotNull((String)"BOOLEAN expected", (Object)b);
        Assert.assertTrue((String)"Unexpected BOOLEAN value", (boolean)b.isTrue());
    }

    public void testReadingMultipleDoubleByteItems() throws IOException {
        ASN1Primitive obj = ASN1Primitive.fromByteArray((byte[])MultipleDoubleByteItems);
        Assert.assertTrue((String)"Null ASN.1 SEQUENCE", (boolean)(obj instanceof ASN1Sequence));
        ASN1Sequence sequence = (ASN1Sequence)obj;
        Assert.assertEquals((String)"2 items expected", (int)2, (int)sequence.size());
        ASN1Enumerated enumerated1 = ASN1Enumerated.getInstance((Object)sequence.getObjectAt(0));
        Assert.assertNotNull((String)"ENUMERATED expected", (Object)enumerated1);
        Assert.assertEquals((String)"Unexpected ENUMERATED value", (int)257, (int)enumerated1.intValueExact());
        Assert.assertTrue((String)"Unexpected ENUMERATED value", (boolean)enumerated1.hasValue(257));
        ASN1Enumerated enumerated2 = ASN1Enumerated.getInstance((Object)sequence.getObjectAt(1));
        Assert.assertNotNull((String)"ENUMERATED expected", (Object)enumerated2);
        Assert.assertEquals((String)"Unexpected ENUMERATED value", (int)514, (int)enumerated2.intValueExact());
        Assert.assertTrue((String)"Unexpected ENUMERATED value", (boolean)enumerated2.hasValue(514));
    }

    public void testReadingMultipleTripleByteItems() throws IOException {
        ASN1Primitive obj = ASN1Primitive.fromByteArray((byte[])MultipleTripleByteItems);
        Assert.assertTrue((String)"Null ASN.1 SEQUENCE", (boolean)(obj instanceof ASN1Sequence));
        ASN1Sequence sequence = (ASN1Sequence)obj;
        Assert.assertEquals((String)"2 items expected", (int)2, (int)sequence.size());
        ASN1Enumerated enumerated = ASN1Enumerated.getInstance((Object)sequence.getObjectAt(0));
        Assert.assertNotNull((String)"ENUMERATED expected", (Object)enumerated);
        Assert.assertEquals((String)"Unexpected ENUMERATED value", (int)65793, (int)enumerated.intValueExact());
        Assert.assertTrue((String)"Unexpected ENUMERATED value", (boolean)enumerated.hasValue(65793));
        ASN1ObjectIdentifier objectId = ASN1ObjectIdentifier.getInstance((Object)sequence.getObjectAt(1));
        Assert.assertNotNull((String)"OBJECT IDENTIFIER expected", (Object)objectId);
        Assert.assertEquals((String)"Unexpected OBJECT IDENTIFIER value", (String)"1.3.6.1", (String)objectId.getId());
    }
}

