/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.asn1.DLExternal;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.util.test.SimpleTest;

public class DLExternalTest
extends SimpleTest {
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERUTF8String;
    static /* synthetic */ Class class$org$bouncycastle$asn1$ASN1Integer;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLSet;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLTaggedObject;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLSequence;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERPrintableString;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DEROctetString;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERIA5String;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLExternal;

    public void testInstantiationByVector() throws Exception {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        try {
            new DLExternal(new DLSequence(vec));
            this.fail("exception expected");
        }
        catch (IllegalArgumentException iae) {
            this.isEquals("check message", "too few objects in input sequence", iae.getMessage());
        }
        vec.add((ASN1Encodable)new DERUTF8String("something completely different"));
        try {
            new DLExternal(new DLSequence(vec));
            this.fail("exception expected");
        }
        catch (IllegalArgumentException iae) {
            this.isEquals("check message", "too few objects in input sequence", iae.getMessage());
        }
        vec.add((ASN1Encodable)new DLTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer(1234567890L)));
        DLExternal dle = new DLExternal(new DLSequence(vec));
        this.isEquals("check direct reference", null, dle.getDirectReference());
        this.isEquals("check indirect reference", null, dle.getIndirectReference());
        this.isTrue("check data value descriptor", dle.getDataValueDescriptor() != null);
        String dvdType = dle.getDataValueDescriptor().getClass().getName();
        this.isEquals("check type of value descriptor: " + dvdType, (class$org$bouncycastle$asn1$DERUTF8String == null ? (class$org$bouncycastle$asn1$DERUTF8String = DLExternalTest.class$("org.bouncycastle.asn1.DERUTF8String")) : class$org$bouncycastle$asn1$DERUTF8String).getName(), dvdType);
        this.isEquals("check value", "something completely different", ((ASN1UTF8String)dle.getDataValueDescriptor()).getString());
        this.isEquals("check encoding", 0L, dle.getEncoding());
        this.isTrue("check existence of external content", dle.getExternalContent() != null);
        String ecType = dle.getExternalContent().getClass().getName();
        this.isEquals("check type of external content: " + ecType, (class$org$bouncycastle$asn1$ASN1Integer == null ? (class$org$bouncycastle$asn1$ASN1Integer = DLExternalTest.class$("org.bouncycastle.asn1.ASN1Integer")) : class$org$bouncycastle$asn1$ASN1Integer).getName(), ecType);
        this.isEquals("check value of external content", "1234567890", ((ASN1Integer)dle.getExternalContent()).getValue().toString());
        vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer(9L));
        vec.add((ASN1Encodable)new DERUTF8String("something completely different"));
        vec.add((ASN1Encodable)new DLTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer(1234567890L)));
        dle = new DLExternal(vec);
        this.isEquals("check direct reference", null, dle.getDirectReference());
        this.isTrue("check existence of indirect reference", dle.getIndirectReference() != null);
        this.isEquals("check indirect reference", "9", dle.getIndirectReference().getValue().toString());
        this.isTrue("check existence of data value descriptor", dle.getDataValueDescriptor() != null);
        dvdType = dle.getDataValueDescriptor().getClass().getName();
        this.isEquals("check type of value descriptor: " + dvdType, (class$org$bouncycastle$asn1$DERUTF8String == null ? (class$org$bouncycastle$asn1$DERUTF8String = DLExternalTest.class$("org.bouncycastle.asn1.DERUTF8String")) : class$org$bouncycastle$asn1$DERUTF8String).getName(), dvdType);
        this.isEquals("check value", "something completely different", ((ASN1UTF8String)dle.getDataValueDescriptor()).getString());
        this.isEquals("check encoding", 0L, dle.getEncoding());
        this.isTrue("check existence of external content", dle.getExternalContent() != null);
        ecType = dle.getExternalContent().getClass().getName();
        this.isEquals("check type of external content: " + ecType, (class$org$bouncycastle$asn1$ASN1Integer == null ? (class$org$bouncycastle$asn1$ASN1Integer = DLExternalTest.class$("org.bouncycastle.asn1.ASN1Integer")) : class$org$bouncycastle$asn1$ASN1Integer).getName(), ecType);
        this.isEquals("check value of external content", "1234567890", ((ASN1Integer)dle.getExternalContent()).getValue().toString());
        dle = new DLExternal(this.createRealDataExample(0));
        this.checkRealDataExample(0, dle);
        dle = new DLExternal(this.createRealDataExample(1));
        this.checkRealDataExample(1, dle);
        dle = new DLExternal(this.createRealDataExample(2));
        this.checkRealDataExample(2, dle);
    }

    public void testReadEncoded() throws Exception {
        this.implTestReadEncoded(0);
        this.implTestReadEncoded(1);
        this.implTestReadEncoded(2);
    }

    private void checkRealDataExample(int encoding, DLExternal dle) throws IOException {
        ASN1TaggedObject msBind;
        this.isEquals("check direct reference", "2.1.1", String.valueOf(dle.getDirectReference()));
        this.isEquals("check indirect reference", "9", String.valueOf(dle.getIndirectReference()));
        this.isEquals("check data value decriptor", "example data representing the User Data of an OSI.6 ConnectP containing an MSBind with username and password", String.valueOf(dle.getDataValueDescriptor()));
        this.isEquals("check encoding", encoding, dle.getEncoding());
        ASN1Primitive content = dle.getExternalContent();
        this.isTrue("check existence of content", content != null);
        switch (encoding) {
            case 1: {
                this.isTrue("check type is an OCTET STRING: " + content.getClass(), content instanceof ASN1OctetString);
                ASN1OctetString octetString = (ASN1OctetString)content;
                msBind = ASN1TaggedObject.getInstance((Object)octetString.getOctets());
                break;
            }
            case 2: {
                this.isTrue("check type is a BIT STRING: " + content.getClass(), content instanceof ASN1BitString);
                ASN1BitString bitString = (ASN1BitString)content;
                msBind = ASN1TaggedObject.getInstance((Object)bitString.getBytes());
                break;
            }
            default: {
                this.isTrue("check type is a tagged object: " + content.getClass(), content instanceof ASN1TaggedObject);
                msBind = (ASN1TaggedObject)content;
            }
        }
        this.isTrue("check tag", msBind.hasContextTag(16));
        this.isEquals("check explicit", true, msBind.isExplicit());
        this.isEquals("check tagged object is a DLSet: " + msBind.getBaseUniversal(true, 17).getClass(), (class$org$bouncycastle$asn1$DLSet == null ? (class$org$bouncycastle$asn1$DLSet = DLExternalTest.class$("org.bouncycastle.asn1.DLSet")) : class$org$bouncycastle$asn1$DLSet).getName(), msBind.getBaseUniversal(true, 17).getClass().getName());
        DLSet msBindSet = (DLSet)msBind.getBaseUniversal(true, 17);
        this.isEquals("check number of elements", 2L, msBindSet.size());
        this.isEquals("check first element in set: " + msBindSet.getObjectAt(0).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject == null ? (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject")) : class$org$bouncycastle$asn1$DLTaggedObject).getName(), msBindSet.getObjectAt(0).getClass().getName());
        DLTaggedObject objectName = (DLTaggedObject)msBindSet.getObjectAt(0);
        this.isEquals("check tag number", true, objectName.hasTag(64, 0));
        this.isEquals("check application object: " + objectName.getBaseObject().toASN1Primitive().getClass(), (class$org$bouncycastle$asn1$DLSequence == null ? (class$org$bouncycastle$asn1$DLSequence = DLExternalTest.class$("org.bouncycastle.asn1.DLSequence")) : class$org$bouncycastle$asn1$DLSequence).getName(), objectName.getBaseObject().toASN1Primitive().getClass().getName());
        DLSequence objNameElems = (DLSequence)objectName.getBaseObject().toASN1Primitive();
        this.isEquals("check number of elements", 4L, objNameElems.size());
        this.isEquals("check first element in set: " + objNameElems.getObjectAt(0).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject == null ? (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject")) : class$org$bouncycastle$asn1$DLTaggedObject).getName(), objNameElems.getObjectAt(0).getClass().getName());
        DLTaggedObject objNameAppl = (DLTaggedObject)objNameElems.getObjectAt(0);
        this.isEquals("check application number", true, objNameAppl.hasTag(64, 0));
        this.isEquals("check application object: " + objNameAppl.getBaseObject().toASN1Primitive().getClass(), (class$org$bouncycastle$asn1$DERPrintableString == null ? (class$org$bouncycastle$asn1$DERPrintableString = DLExternalTest.class$("org.bouncycastle.asn1.DERPrintableString")) : class$org$bouncycastle$asn1$DERPrintableString).getName(), objNameAppl.getBaseObject().toASN1Primitive().getClass().getName());
        this.isEquals("check C", "de", ((DERPrintableString)objNameAppl.getBaseObject().toASN1Primitive()).getString());
        this.isEquals("check second element in set: " + objNameElems.getObjectAt(1).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject == null ? (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject")) : class$org$bouncycastle$asn1$DLTaggedObject).getName(), objNameElems.getObjectAt(1).getClass().getName());
        objNameAppl = (DLTaggedObject)objNameElems.getObjectAt(1);
        this.isEquals("check application number", true, objNameAppl.hasTag(64, 2));
        this.isEquals("check application object: " + objNameAppl.getBaseObject().toASN1Primitive().getClass(), (class$org$bouncycastle$asn1$DERPrintableString == null ? (class$org$bouncycastle$asn1$DERPrintableString = DLExternalTest.class$("org.bouncycastle.asn1.DERPrintableString")) : class$org$bouncycastle$asn1$DERPrintableString).getName(), objNameAppl.getBaseObject().toASN1Primitive().getClass().getName());
        this.isEquals("check A", "viaT", ((DERPrintableString)objNameAppl.getBaseObject().toASN1Primitive()).getString());
        this.isEquals("check third element in set: " + objNameElems.getObjectAt(2).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject == null ? (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject")) : class$org$bouncycastle$asn1$DLTaggedObject).getName(), objNameElems.getObjectAt(2).getClass().getName());
        DLTaggedObject objNameTagged = (DLTaggedObject)objNameElems.getObjectAt(2);
        this.isTrue("check tag", objNameTagged.hasContextTag(3));
        this.isEquals("check implicit", false, objNameTagged.isExplicit());
        this.isEquals("check tagged object: " + objNameTagged.getBaseUniversal(false, 4).getClass(), (class$org$bouncycastle$asn1$DEROctetString == null ? (class$org$bouncycastle$asn1$DEROctetString = DLExternalTest.class$("org.bouncycastle.asn1.DEROctetString")) : class$org$bouncycastle$asn1$DEROctetString).getName(), objNameTagged.getBaseUniversal(false, 4).getClass().getName());
        this.isEquals("check O", "Organization", new String(((DEROctetString)objNameTagged.getBaseUniversal(false, 4)).getOctets(), "8859_1"));
        this.isEquals("check fourth element in set: " + objNameElems.getObjectAt(3).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject == null ? (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject")) : class$org$bouncycastle$asn1$DLTaggedObject).getName(), objNameElems.getObjectAt(3).getClass().getName());
        objNameTagged = (DLTaggedObject)objNameElems.getObjectAt(3);
        this.isTrue("check tag", objNameTagged.hasContextTag(5));
        this.isEquals("check explicit", true, objNameTagged.isExplicit());
        this.isEquals("check tagged object: " + objNameTagged.getExplicitBaseTagged().getClass(), (class$org$bouncycastle$asn1$DLTaggedObject == null ? (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject")) : class$org$bouncycastle$asn1$DLTaggedObject).getName(), objNameTagged.getExplicitBaseTagged().getClass().getName());
        objNameTagged = (DLTaggedObject)objNameTagged.getExplicitBaseTagged();
        this.isTrue("check tag", objNameTagged.hasContextTag(0));
        this.isEquals("check implicit", false, objNameTagged.isExplicit());
        this.isEquals("check tagged object: " + objNameTagged.getBaseUniversal(false, 4).getClass(), (class$org$bouncycastle$asn1$DEROctetString == null ? (class$org$bouncycastle$asn1$DEROctetString = DLExternalTest.class$("org.bouncycastle.asn1.DEROctetString")) : class$org$bouncycastle$asn1$DEROctetString).getName(), objNameTagged.getBaseUniversal(false, 4).getClass().getName());
        this.isEquals("check CN", "Common Name", new String(((DEROctetString)objNameTagged.getBaseUniversal(false, 4)).getOctets(), "8859_1"));
        this.isEquals("check second element in set: " + msBindSet.getObjectAt(1).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject == null ? (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject")) : class$org$bouncycastle$asn1$DLTaggedObject).getName(), msBindSet.getObjectAt(1).getClass().getName());
        DLTaggedObject password = (DLTaggedObject)msBindSet.getObjectAt(1);
        this.isTrue("check tag", password.hasContextTag(2));
        this.isEquals("check explicit", true, password.isExplicit());
        this.isEquals("check tagged object: " + password.getBaseUniversal(true, 22).getClass(), (class$org$bouncycastle$asn1$DERIA5String == null ? (class$org$bouncycastle$asn1$DERIA5String = DLExternalTest.class$("org.bouncycastle.asn1.DERIA5String")) : class$org$bouncycastle$asn1$DERIA5String).getName(), password.getBaseUniversal(true, 22).getClass().getName());
        this.isEquals("check password", "SomePassword", ((ASN1IA5String)password.getBaseUniversal(true, 22)).getString());
    }

    private ASN1EncodableVector createRealDataExample(int encoding) throws IOException {
        DLTaggedObject msBind;
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1ObjectIdentifier("2.1.1"));
        vec.add((ASN1Encodable)new ASN1Integer(9L));
        vec.add((ASN1Encodable)new DERUTF8String("example data representing the User Data of an OSI.6 ConnectP containing an MSBind with username and password"));
        ASN1EncodableVector objectNameVec = new ASN1EncodableVector();
        objectNameVec.add((ASN1Encodable)new DLTaggedObject(64, 0, (ASN1Encodable)new DERPrintableString("de")));
        objectNameVec.add((ASN1Encodable)new DLTaggedObject(64, 2, (ASN1Encodable)new DERPrintableString("viaT")));
        objectNameVec.add((ASN1Encodable)new DLTaggedObject(false, 3, (ASN1Encodable)new DEROctetString("Organization".getBytes("8859_1"))));
        objectNameVec.add((ASN1Encodable)new DLTaggedObject(true, 5, (ASN1Encodable)new DLTaggedObject(false, 0, (ASN1Encodable)new DEROctetString("Common Name".getBytes("8859_1")))));
        DLTaggedObject objectName = new DLTaggedObject(64, 0, (ASN1Encodable)new DLSequence(objectNameVec));
        DLTaggedObject password = new DLTaggedObject(true, 2, (ASN1Encodable)new DERIA5String("SomePassword"));
        ASN1EncodableVector msBindVec = new ASN1EncodableVector();
        msBindVec.add((ASN1Encodable)objectName);
        msBindVec.add((ASN1Encodable)password);
        DLSet msBindSet = new DLSet(msBindVec);
        DLTaggedObject obj = msBind = new DLTaggedObject(true, 16, (ASN1Encodable)msBindSet);
        switch (encoding) {
            case 1: {
                obj = new DEROctetString(obj.getEncoded("DL"));
                break;
            }
            case 2: {
                obj = new DLBitString(obj.getEncoded("DL"));
            }
        }
        vec.add((ASN1Encodable)new DLTaggedObject(0 == encoding, encoding, (ASN1Encodable)obj));
        return vec;
    }

    private void implTestReadEncoded(int encoding) throws Exception {
        DLExternal dle = new DLExternal(this.createRealDataExample(encoding));
        ASN1InputStream ais = new ASN1InputStream(dle.getEncoded());
        ASN1Primitive ap = ais.readObject();
        this.isTrue("check ais returned an object", ap != null);
        this.isEquals("check returned type: " + ap.getClass(), (class$org$bouncycastle$asn1$DLExternal == null ? (class$org$bouncycastle$asn1$DLExternal = DLExternalTest.class$("org.bouncycastle.asn1.DLExternal")) : class$org$bouncycastle$asn1$DLExternal).getName(), ap.getClass().getName());
        this.checkRealDataExample(encoding, (DLExternal)ap);
        ais.close();
    }

    public String getName() {
        return "DLExternal";
    }

    public void performTest() throws Exception {
        this.testInstantiationByVector();
        this.testReadEncoded();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new DLExternalTest());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

