/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.internal.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class CertIDTest
extends SimpleTest {
    public String getName() {
        return "CertID";
    }

    public void performTest() throws Exception {
        DEROctetString issuerAHash = new DEROctetString(Strings.toByteArray((String)"IssuerAHash"));
        DEROctetString issuerBHash = new DEROctetString(Strings.toByteArray((String)"IssuerBHash"));
        DEROctetString issuerAKeyHash = new DEROctetString(Strings.toByteArray((String)"IssuerAKeyHash"));
        DEROctetString issuerBKeyHash = new DEROctetString(Strings.toByteArray((String)"IssuerBKeyHash"));
        CertID a = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), (ASN1OctetString)issuerAHash, (ASN1OctetString)issuerAKeyHash, new ASN1Integer(BigIntegers.ONE));
        CertID b = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE), (ASN1OctetString)issuerAHash, (ASN1OctetString)issuerAKeyHash, new ASN1Integer(BigIntegers.ONE));
        CertID c = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)new DEROctetString(new byte[1])), (ASN1OctetString)issuerAHash, (ASN1OctetString)issuerAKeyHash, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(a.equals((Object)a));
        this.isTrue(a.equals((Object)b));
        this.isTrue(a.hashCode() == b.hashCode());
        this.isTrue(!a.equals((Object)c));
        this.isTrue(a.hashCode() != c.hashCode());
        b = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), (ASN1OctetString)issuerAHash, (ASN1OctetString)issuerAKeyHash, new ASN1Integer(BigIntegers.TWO));
        this.isTrue(!a.equals((Object)b));
        b = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm), (ASN1OctetString)issuerAHash, (ASN1OctetString)issuerAKeyHash, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(!a.equals((Object)b));
        b = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), (ASN1OctetString)issuerBHash, (ASN1OctetString)issuerAKeyHash, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(!a.equals((Object)b));
        b = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), (ASN1OctetString)issuerAHash, (ASN1OctetString)issuerBKeyHash, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(!a.equals((Object)b));
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new CertIDTest());
    }
}

