/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.util.encoders.Hex;

public class ASN1SequenceParserTest
extends TestCase {
    private static final byte[] seqData = Hex.decode((String)"3006020100060129");
    private static final byte[] nestedSeqData = Hex.decode((String)"300b0201000601293003020101");
    private static final byte[] expTagSeqData = Hex.decode((String)"a1083006020100060129");
    private static final byte[] implTagSeqData = Hex.decode((String)"a106020100060129");
    private static final byte[] nestedSeqExpTagData = Hex.decode((String)"300d020100060129a1053003020101");
    private static final byte[] nestedSeqImpTagData = Hex.decode((String)"300b020100060129a103020101");
    private static final byte[] berSeqData = Hex.decode((String)"30800201000601290000");
    private static final byte[] berDERNestedSeqData = Hex.decode((String)"308002010006012930030201010000");
    private static final byte[] berNestedSeqData = Hex.decode((String)"3080020100060129308002010100000000");
    private static final byte[] berExpTagSeqData = Hex.decode((String)"a180308002010006012900000000");
    private static final byte[] berSeqWithDERNullData = Hex.decode((String)"308005000201000601290000");
    static /* synthetic */ Class class$org$bouncycastle$asn1$test$ASN1SequenceParserTest;

    public void testDERWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DERSequenceGenerator seqGen = new DERSequenceGenerator((OutputStream)bOut);
        seqGen.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        seqGen.close();
        Assert.assertTrue((String)"basic DER writing test failed.", (boolean)Arrays.equals(seqData, bOut.toByteArray()));
    }

    public void testNestedDERWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DERSequenceGenerator seqGen1 = new DERSequenceGenerator((OutputStream)bOut);
        seqGen1.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen1.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        DERSequenceGenerator seqGen2 = new DERSequenceGenerator(seqGen1.getRawOutputStream());
        seqGen2.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(1L)));
        seqGen2.close();
        seqGen1.close();
        Assert.assertTrue((String)"nested DER writing test failed.", (boolean)Arrays.equals(nestedSeqData, bOut.toByteArray()));
    }

    public void testDERExplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DERSequenceGenerator seqGen = new DERSequenceGenerator((OutputStream)bOut, 1, true);
        seqGen.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        seqGen.close();
        Assert.assertTrue((String)"explicit tag writing test failed.", (boolean)Arrays.equals(expTagSeqData, bOut.toByteArray()));
    }

    public void testDERImplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DERSequenceGenerator seqGen = new DERSequenceGenerator((OutputStream)bOut, 1, false);
        seqGen.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        seqGen.close();
        Assert.assertTrue((String)"implicit tag writing test failed.", (boolean)Arrays.equals(implTagSeqData, bOut.toByteArray()));
    }

    public void testNestedExplicitTagDERWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DERSequenceGenerator seqGen1 = new DERSequenceGenerator((OutputStream)bOut);
        seqGen1.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen1.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        DERSequenceGenerator seqGen2 = new DERSequenceGenerator(seqGen1.getRawOutputStream(), 1, true);
        seqGen2.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(1L)));
        seqGen2.close();
        seqGen1.close();
        Assert.assertTrue((String)"nested explicit tagged DER writing test failed.", (boolean)Arrays.equals(nestedSeqExpTagData, bOut.toByteArray()));
    }

    public void testNestedImplicitTagDERWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DERSequenceGenerator seqGen1 = new DERSequenceGenerator((OutputStream)bOut);
        seqGen1.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen1.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        DERSequenceGenerator seqGen2 = new DERSequenceGenerator(seqGen1.getRawOutputStream(), 1, false);
        seqGen2.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(1L)));
        seqGen2.close();
        seqGen1.close();
        Assert.assertTrue((String)"nested implicit tagged DER writing test failed.", (boolean)Arrays.equals(nestedSeqImpTagData, bOut.toByteArray()));
    }

    public void testBERWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BERSequenceGenerator seqGen = new BERSequenceGenerator((OutputStream)bOut);
        seqGen.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        seqGen.close();
        Assert.assertTrue((String)"basic BER writing test failed.", (boolean)Arrays.equals(berSeqData, bOut.toByteArray()));
    }

    public void testNestedBERDERWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BERSequenceGenerator seqGen1 = new BERSequenceGenerator((OutputStream)bOut);
        seqGen1.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen1.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        DERSequenceGenerator seqGen2 = new DERSequenceGenerator(seqGen1.getRawOutputStream());
        seqGen2.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(1L)));
        seqGen2.close();
        seqGen1.close();
        Assert.assertTrue((String)"nested BER/DER writing test failed.", (boolean)Arrays.equals(berDERNestedSeqData, bOut.toByteArray()));
    }

    public void testNestedBERWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BERSequenceGenerator seqGen1 = new BERSequenceGenerator((OutputStream)bOut);
        seqGen1.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen1.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        BERSequenceGenerator seqGen2 = new BERSequenceGenerator(seqGen1.getRawOutputStream());
        seqGen2.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(1L)));
        seqGen2.close();
        seqGen1.close();
        Assert.assertTrue((String)"nested BER writing test failed.", (boolean)Arrays.equals(berNestedSeqData, bOut.toByteArray()));
    }

    /*
     * WARNING - void declaration
     */
    public void testDERReading() throws Exception {
        ASN1Encodable o;
        ASN1StreamParser aIn = new ASN1StreamParser(seqData);
        ASN1SequenceParser seq = (ASN1SequenceParser)aIn.readObject();
        int count = 0;
        Assert.assertNotNull((String)"null sequence returned", (Object)seq);
        while ((o = seq.readObject()) != null) {
            switch (count) {
                case 0: {
                    void var3_4;
                    Assert.assertTrue((boolean)(var3_4 instanceof ASN1Integer));
                    break;
                }
                case 1: {
                    void var3_4;
                    Assert.assertTrue((boolean)(var3_4 instanceof ASN1ObjectIdentifier));
                }
            }
            ++count;
        }
        Assert.assertEquals((String)"wrong number of objects in sequence", (int)2, (int)count);
    }

    /*
     * WARNING - void declaration
     */
    private void testNestedReading(byte[] data) throws Exception {
        ASN1Encodable o;
        ASN1StreamParser aIn = new ASN1StreamParser(data);
        ASN1SequenceParser seq = (ASN1SequenceParser)aIn.readObject();
        int count = 0;
        Assert.assertNotNull((String)"null sequence returned", (Object)seq);
        while ((o = seq.readObject()) != null) {
            switch (count) {
                case 0: {
                    void var4_5;
                    Assert.assertTrue((boolean)(var4_5 instanceof ASN1Integer));
                    break;
                }
                case 1: {
                    void var4_5;
                    Assert.assertTrue((boolean)(var4_5 instanceof ASN1ObjectIdentifier));
                    break;
                }
                case 2: {
                    void var4_5;
                    Assert.assertTrue((boolean)(var4_5 instanceof ASN1SequenceParser));
                    ASN1SequenceParser s = (ASN1SequenceParser)var4_5;
                    while (s.readObject() != null) {
                    }
                    break;
                }
            }
            ++count;
        }
        Assert.assertEquals((String)"wrong number of objects in sequence", (int)3, (int)count);
    }

    public void testNestedDERReading() throws Exception {
        this.testNestedReading(nestedSeqData);
    }

    /*
     * WARNING - void declaration
     */
    public void testBERReading() throws Exception {
        ASN1Encodable o;
        ASN1StreamParser aIn = new ASN1StreamParser(berSeqData);
        ASN1SequenceParser seq = (ASN1SequenceParser)aIn.readObject();
        int count = 0;
        Assert.assertNotNull((String)"null sequence returned", (Object)seq);
        while ((o = seq.readObject()) != null) {
            switch (count) {
                case 0: {
                    void var3_4;
                    Assert.assertTrue((boolean)(var3_4 instanceof ASN1Integer));
                    break;
                }
                case 1: {
                    void var3_4;
                    Assert.assertTrue((boolean)(var3_4 instanceof ASN1ObjectIdentifier));
                }
            }
            ++count;
        }
        Assert.assertEquals((String)"wrong number of objects in sequence", (int)2, (int)count);
    }

    public void testNestedBERDERReading() throws Exception {
        this.testNestedReading(berDERNestedSeqData);
    }

    public void testNestedBERReading() throws Exception {
        this.testNestedReading(berNestedSeqData);
    }

    public void testBERExplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BERSequenceGenerator seqGen = new BERSequenceGenerator((OutputStream)bOut, 1, true);
        seqGen.addObject((ASN1Primitive)new ASN1Integer(BigInteger.valueOf(0L)));
        seqGen.addObject((ASN1Primitive)new ASN1ObjectIdentifier("1.1"));
        seqGen.close();
        Assert.assertTrue((String)"explicit BER tag writing test failed.", (boolean)Arrays.equals(berExpTagSeqData, bOut.toByteArray()));
    }

    public void testSequenceWithDERNullReading() throws Exception {
        this.testParseWithNull(berSeqWithDERNullData);
    }

    /*
     * WARNING - void declaration
     */
    private void testParseWithNull(byte[] data) throws IOException {
        ASN1Encodable o;
        ASN1StreamParser aIn = new ASN1StreamParser(data);
        ASN1SequenceParser seq = (ASN1SequenceParser)aIn.readObject();
        int count = 0;
        Assert.assertNotNull((String)"null sequence returned", (Object)seq);
        while ((o = seq.readObject()) != null) {
            switch (count) {
                case 0: {
                    void var4_5;
                    Assert.assertTrue((boolean)(var4_5 instanceof ASN1Null));
                    break;
                }
                case 1: {
                    void var4_5;
                    Assert.assertTrue((boolean)(var4_5 instanceof ASN1Integer));
                    break;
                }
                case 2: {
                    void var4_5;
                    Assert.assertTrue((boolean)(var4_5 instanceof ASN1ObjectIdentifier));
                }
            }
            ++count;
        }
        Assert.assertEquals((String)"wrong number of objects in sequence", (int)3, (int)count);
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$asn1$test$ASN1SequenceParserTest == null ? (class$org$bouncycastle$asn1$test$ASN1SequenceParserTest = ASN1SequenceParserTest.class$("org.bouncycastle.asn1.test.ASN1SequenceParserTest")) : class$org$bouncycastle$asn1$test$ASN1SequenceParserTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

