/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.math.BigInteger;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ASN1IntegerTest
extends SimpleTest {
    private static final byte[] suspectKey = Base64.decode((String)"MIGJAoGBAHNc+iExm94LUrJdPSJ4QJ9tDRuvaNmGVHpJ4X7a5zKI02v+2E7RotuiR2MHDJfVJkb9LUs2kb3XBlyENhtMLsbeH+3Muy3hGDlh/mLJSh1s4c5jDKBRYOHom7Uc8wP0P2+zBCA+OEdikNDFBaP5PbR2Xq9okG2kPh35M2quAiMTAgMBAAE=");

    public String getName() {
        return "ASN1Integer";
    }

    public void performTest() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        ASN1Sequence.getInstance((Object)suspectKey);
        this.testValidEncodingSingleByte();
        this.testValidEncodingMultiByte();
        this.testInvalidEncoding_00();
        this.testInvalidEncoding_ff();
        this.testInvalidEncoding_00_32bits();
        this.testInvalidEncoding_ff_32bits();
        this.testLooseValidEncoding_zero_32BAligned();
        this.testLooseValidEncoding_FF_32BAligned();
        this.testLooseValidEncoding_FF_32BAligned_1not0();
        this.testLooseValidEncoding_FF_32BAligned_2not0();
        this.testOversizedEncoding();
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        new ASN1Integer(Hex.decode((String)"ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
        new ASN1Enumerated(Hex.decode((String)"005a47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            new ASN1Integer(Hex.decode((String)"ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
        this.isTrue(!Properties.setThreadOverride((String)"org.bouncycastle.asn1.allow_unsafe_integer", (boolean)true));
        new ASN1Integer(Hex.decode((String)"ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b"));
        this.isTrue(Properties.removeThreadOverride((String)"org.bouncycastle.asn1.allow_unsafe_integer"));
        try {
            ASN1Sequence.getInstance((Object)suspectKey);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("test 1: " + e.getMessage(), "failed to construct sequence from byte[]: malformed integer", e.getMessage());
        }
        try {
            new ASN1Integer(Hex.decode((String)"ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
        try {
            new ASN1Enumerated(Hex.decode((String)"ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed enumerated", e.getMessage());
        }
        try {
            new ASN1Enumerated(Hex.decode((String)"005a47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed enumerated", e.getMessage());
        }
    }

    public void testValidEncodingSingleByte() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        byte[] rawInt = Hex.decode((String)"10");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.checkIntValue(i, 16);
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        rawInt = Hex.decode((String)"10");
        i = new ASN1Integer(rawInt);
        this.checkIntValue(i, 16);
    }

    public void testValidEncodingMultiByte() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        byte[] rawInt = Hex.decode((String)"10FF");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.checkIntValue(i, 4351);
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        rawInt = Hex.decode((String)"10FF");
        i = new ASN1Integer(rawInt);
        this.checkIntValue(i, 4351);
    }

    public void testInvalidEncoding_00() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode((String)"0010FF");
            new ASN1Integer(rawInt);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testInvalidEncoding_ff() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode((String)"FF81FF");
            new ASN1Integer(rawInt);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testInvalidEncoding_00_32bits() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode((String)"0000000010FF");
            new ASN1Integer(rawInt);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testInvalidEncoding_ff_32bits() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode((String)"FFFFFFFF01FF");
            new ASN1Integer(rawInt);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testLooseValidEncoding_zero_32BAligned() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode((String)"00000010FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.checkLongValue(i, 0x10FF000000L);
    }

    public void testLooseValidEncoding_FF_32BAligned() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode((String)"FFFFFF10FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.checkLongValue(i, -1026513960960L);
    }

    public void testLooseValidEncoding_FF_32BAligned_1not0() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode((String)"FFFEFF10FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.checkLongValue(i, -282501490671616L);
    }

    public void testLooseValidEncoding_FF_32BAligned_2not0() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode((String)"FFFFFE10FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.checkLongValue(i, -2126025588736L);
    }

    public void testOversizedEncoding() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode((String)"FFFFFFFE10FF000000000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(new BigInteger(Hex.decode((String)"FFFFFFFE10FF000000000000")), i.getValue());
        rawInt = Hex.decode((String)"FFFFFFFFFE10FF000000000000");
        try {
            new ASN1Integer(rawInt);
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    private void checkIntValue(ASN1Integer i, int n) {
        BigInteger val = i.getValue();
        this.isEquals(val.intValue(), n);
        this.isEquals(BigIntegers.intValueExact((BigInteger)val), n);
        this.isEquals(i.intValueExact(), n);
        this.isTrue(i.hasValue(n));
    }

    private void checkLongValue(ASN1Integer i, long n) {
        BigInteger val = i.getValue();
        this.isEquals(val.longValue(), n);
        this.isEquals(BigIntegers.longValueExact((BigInteger)val), n);
        this.isEquals(i.longValueExact(), n);
        this.isTrue(i.hasValue(n));
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ASN1IntegerTest());
    }
}

