/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.ers.ByteArrayComparator;
import org.bouncycastle.tsp.ers.ERSData;
import org.bouncycastle.tsp.ers.ExpUtil;
import org.bouncycastle.tsp.ers.IndexedHash;
import org.bouncycastle.tsp.ers.SortedHashList;
import org.bouncycastle.tsp.ers.SortedIndexedHashList;
import org.bouncycastle.util.io.Streams;

class ERSUtil {
    private static final Comparator hashComp = new ByteArrayComparator();

    private ERSUtil() {
    }

    static byte[] calculateDigest(DigestCalculator digCalc, byte[] data) {
        try {
            OutputStream mdOut = digCalc.getOutputStream();
            mdOut.write(data);
            mdOut.close();
            return digCalc.getDigest();
        }
        catch (IOException e) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + e.getMessage(), e);
        }
    }

    static byte[] calculateBranchHash(DigestCalculator digCalc, byte[] a, byte[] b) {
        if (hashComp.compare(a, b) <= 0) {
            return ERSUtil.calculateDigest(digCalc, a, b);
        }
        return ERSUtil.calculateDigest(digCalc, b, a);
    }

    static byte[] calculateBranchHash(DigestCalculator digCalc, byte[][] values) {
        if (values.length == 2) {
            return ERSUtil.calculateBranchHash(digCalc, values[0], values[1]);
        }
        return ERSUtil.calculateDigest(digCalc, ERSUtil.buildIndexedHashList(values).iterator());
    }

    static byte[] calculateDigest(DigestCalculator digCalc, byte[] a, byte[] b) {
        try {
            OutputStream mdOut = digCalc.getOutputStream();
            mdOut.write(a);
            mdOut.write(b);
            mdOut.close();
            return digCalc.getDigest();
        }
        catch (IOException e) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + e.getMessage(), e);
        }
    }

    static byte[] calculateDigest(DigestCalculator digCalc, Iterator dataGroup) {
        try {
            OutputStream mdOut = digCalc.getOutputStream();
            while (dataGroup.hasNext()) {
                mdOut.write((byte[])dataGroup.next());
            }
            mdOut.close();
            return digCalc.getDigest();
        }
        catch (IOException e) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + e.getMessage(), e);
        }
    }

    static byte[] calculateDigest(DigestCalculator digCalc, InputStream inStream) {
        try {
            OutputStream mdOut = digCalc.getOutputStream();
            Streams.pipeAll((InputStream)inStream, (OutputStream)mdOut);
            mdOut.close();
            return digCalc.getDigest();
        }
        catch (IOException e) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + e.getMessage(), e);
        }
    }

    static byte[] computeNodeHash(DigestCalculator digCalc, PartialHashtree node) {
        byte[][] values = node.getValues();
        if (values.length > 1) {
            return ERSUtil.calculateDigest(digCalc, ERSUtil.buildIndexedHashList(values).iterator());
        }
        return values[0];
    }

    static List buildIndexedHashList(byte[][] values) {
        SortedHashList hashes = new SortedHashList();
        int i = 0;
        while (i != values.length) {
            hashes.add(values[i]);
            ++i;
        }
        return hashes.toList();
    }

    static List buildHashList(DigestCalculator digCalc, List dataObjects, byte[] previousChainHash) {
        SortedHashList hashes = new SortedHashList();
        int i = 0;
        while (i != dataObjects.size()) {
            hashes.add(((ERSData)dataObjects.get(i)).getHash(digCalc, previousChainHash));
            ++i;
        }
        return hashes.toList();
    }

    static List buildIndexedHashList(DigestCalculator digCalc, List dataObjects, byte[] previousChainsHash) {
        SortedIndexedHashList hashes = new SortedIndexedHashList();
        int i = 0;
        while (i != dataObjects.size()) {
            byte[] hash = ((ERSData)dataObjects.get(i)).getHash(digCalc, previousChainsHash);
            hashes.add(new IndexedHash(i, hash));
            ++i;
        }
        return hashes.toList();
    }

    static byte[] concatPreviousHashes(DigestCalculator digCalc, byte[] chainHash, byte[] dataHash) {
        if (chainHash == null) {
            return dataHash;
        }
        try {
            OutputStream digOut = digCalc.getOutputStream();
            digOut.write(dataHash);
            digOut.write(chainHash);
            digOut.close();
            return digCalc.getDigest();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to hash data");
        }
    }
}

