/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.ers.ERSCachingData;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.tsp.ers.ExpUtil;
import org.bouncycastle.util.io.Streams;

public class ERSInputStreamData
extends ERSCachingData {
    private final File contentFile;
    private final byte[] contentBytes;

    public ERSInputStreamData(File content) throws FileNotFoundException {
        if (content.isDirectory()) {
            throw new IllegalArgumentException("directory not allowed");
        }
        if (!content.exists()) {
            throw new FileNotFoundException(content + " not found");
        }
        this.contentBytes = null;
        this.contentFile = content;
    }

    public ERSInputStreamData(InputStream content) {
        try {
            this.contentBytes = Streams.readAll((InputStream)content);
        }
        catch (IOException e) {
            throw ExpUtil.createIllegalState("unable to open content: " + e.getMessage(), e);
        }
        this.contentFile = null;
    }

    protected byte[] calculateHash(DigestCalculator digestCalculator, byte[] previousChainHash) {
        byte[] hash;
        if (this.contentBytes != null) {
            hash = ERSUtil.calculateDigest(digestCalculator, this.contentBytes);
        } else {
            try {
                FileInputStream content = new FileInputStream(this.contentFile);
                hash = ERSUtil.calculateDigest(digestCalculator, content);
                ((InputStream)content).close();
            }
            catch (IOException e) {
                throw ExpUtil.createIllegalState("unable to open content: " + e.getMessage(), e);
            }
        }
        if (previousChainHash != null) {
            return ERSUtil.concatPreviousHashes(digestCalculator, previousChainHash, hash);
        }
        return hash;
    }
}

