/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.ers.ERSEvidenceRecord;
import org.bouncycastle.tsp.ers.ERSEvidenceRecordSelector;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;

public class ERSEvidenceRecordStore
implements Store {
    private Map recordMap = new HashMap();
    private DigestCalculator digCalc = null;

    public ERSEvidenceRecordStore(Collection records) throws OperatorCreationException {
        Iterator it = records.iterator();
        while (it.hasNext()) {
            PartialHashtree dataLeaf;
            ERSEvidenceRecord record = (ERSEvidenceRecord)it.next();
            ArchiveTimeStamp archiveTimeStamp = record.getArchiveTimeStamps()[0];
            if (this.digCalc == null) {
                DigestCalculatorProvider digProv = record.getDigestAlgorithmProvider();
                this.digCalc = digProv.get(archiveTimeStamp.getDigestAlgorithmIdentifier());
            }
            if ((dataLeaf = archiveTimeStamp.getHashTreeLeaf()) != null) {
                byte[][] dataHashes = dataLeaf.getValues();
                if (dataHashes.length > 1) {
                    int i = 0;
                    while (i != dataHashes.length) {
                        this.addRecord(new HashNode(dataHashes[i]), record);
                        ++i;
                    }
                    this.addRecord(new HashNode(ERSUtil.computeNodeHash(this.digCalc, dataLeaf)), record);
                    continue;
                }
                this.addRecord(new HashNode(dataHashes[0]), record);
                continue;
            }
            this.addRecord(new HashNode(archiveTimeStamp.getTimeStampDigestValue()), record);
        }
    }

    private void addRecord(HashNode hashNode, ERSEvidenceRecord record) {
        List recs = (List)this.recordMap.get(hashNode);
        if (recs != null) {
            ArrayList<ERSEvidenceRecord> newRecs = new ArrayList<ERSEvidenceRecord>(recs.size() + 1);
            newRecs.addAll(recs);
            newRecs.add(record);
            this.recordMap.put(hashNode, newRecs);
        } else {
            this.recordMap.put(hashNode, Collections.singletonList(record));
        }
    }

    public Collection getMatches(Selector selector) throws StoreException {
        if (selector instanceof ERSEvidenceRecordSelector) {
            HashNode node = new HashNode(((ERSEvidenceRecordSelector)selector).getData().getHash(this.digCalc, null));
            List records = (List)this.recordMap.get(node);
            if (records != null) {
                ArrayList<ERSEvidenceRecord> rv = new ArrayList<ERSEvidenceRecord>(records.size());
                int i = 0;
                while (i != records.size()) {
                    ERSEvidenceRecord record = (ERSEvidenceRecord)records.get(i);
                    if (selector.match((Object)record)) {
                        rv.add(record);
                    }
                    ++i;
                }
                return Collections.unmodifiableList(rv);
            }
            return Collections.unmodifiableList(new ArrayList());
        }
        if (selector == null) {
            HashSet rv = new HashSet(this.recordMap.size());
            Iterator it = this.recordMap.values().iterator();
            while (it.hasNext()) {
                rv.addAll((List)it.next());
            }
            return Collections.unmodifiableList(new ArrayList(rv));
        }
        HashSet rv = new HashSet();
        Iterator it = this.recordMap.values().iterator();
        while (it.hasNext()) {
            List next = (List)it.next();
            int i = 0;
            while (i != next.size()) {
                if (selector.match(next.get(i))) {
                    rv.add(next.get(i));
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(new ArrayList(rv));
    }

    private static class HashNode {
        private final byte[] dataHash;
        private final int hashCode;

        public HashNode(byte[] dataHash) {
            this.dataHash = dataHash;
            this.hashCode = Arrays.hashCode((byte[])dataHash);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof HashNode) {
                return Arrays.areEqual((byte[])this.dataHash, (byte[])((HashNode)o).dataHash);
            }
            return false;
        }
    }
}

