/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.tsp.ers.ERSCachingData;
import org.bouncycastle.tsp.ers.ERSDataGroup;
import org.bouncycastle.tsp.ers.ERSFileData;

public class ERSDirectoryDataGroup
extends ERSDataGroup {
    public ERSDirectoryDataGroup(File dataDirectory) throws FileNotFoundException {
        super(ERSDirectoryDataGroup.buildGroup(dataDirectory));
    }

    private static List buildGroup(File dataDirectory) throws FileNotFoundException {
        if (dataDirectory.isDirectory()) {
            File[] files = dataDirectory.listFiles();
            ArrayList<ERSCachingData> dataObjects = new ArrayList<ERSCachingData>(files.length);
            int i = 0;
            while (i != files.length) {
                if (files[i].isDirectory()) {
                    if (files[i].listFiles().length != 0) {
                        dataObjects.add(new ERSDirectoryDataGroup(files[i]));
                    }
                } else {
                    dataObjects.add(new ERSFileData(files[i]));
                }
                ++i;
            }
            return dataObjects;
        }
        throw new IllegalArgumentException("file reference does not refer to directory");
    }

    public List getFiles() {
        ArrayList<ERSFileData> files = new ArrayList<ERSFileData>();
        int i = 0;
        while (i != this.dataObjects.size()) {
            if (this.dataObjects.get(i) instanceof ERSFileData) {
                files.add((ERSFileData)this.dataObjects.get(i));
            }
            ++i;
        }
        return files;
    }

    public List getSubdirectories() {
        ArrayList<ERSDirectoryDataGroup> subdirectories = new ArrayList<ERSDirectoryDataGroup>();
        int i = 0;
        while (i != this.dataObjects.size()) {
            if (this.dataObjects.get(i) instanceof ERSDirectoryDataGroup) {
                subdirectories.add((ERSDirectoryDataGroup)this.dataObjects.get(i));
            }
            ++i;
        }
        return subdirectories;
    }
}

