/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampSequence;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.ers.BinaryTreeRootCalculator;
import org.bouncycastle.tsp.ers.ERSArchiveTimeStamp;
import org.bouncycastle.tsp.ers.ERSData;
import org.bouncycastle.tsp.ers.ERSDataGroup;
import org.bouncycastle.tsp.ers.ERSException;
import org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.tsp.ers.IndexedHash;
import org.bouncycastle.util.Arrays;

public class ERSArchiveTimeStampGenerator {
    private final DigestCalculator digCalc;
    private List dataObjects = new ArrayList();
    private ERSRootNodeCalculator rootNodeCalculator = new BinaryTreeRootCalculator();
    private byte[] previousChainHash;

    public ERSArchiveTimeStampGenerator(DigestCalculator digCalc) {
        this.digCalc = digCalc;
    }

    public void addData(ERSData dataObject) {
        this.dataObjects.add(dataObject);
    }

    public void addAllData(List dataObjects) {
        this.dataObjects.addAll(dataObjects);
    }

    void addPreviousChains(ArchiveTimeStampSequence archiveTimeStampSequence) throws IOException {
        OutputStream digOut = this.digCalc.getOutputStream();
        digOut.write(archiveTimeStampSequence.getEncoded("DER"));
        digOut.close();
        this.previousChainHash = this.digCalc.getDigest();
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator tspReqGenerator) throws TSPException, IOException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        return tspReqGenerator.generate(this.digCalc.getAlgorithmIdentifier(), rootHash);
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator tspReqGenerator, BigInteger nonce) throws TSPException, IOException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        return tspReqGenerator.generate(this.digCalc.getAlgorithmIdentifier(), rootHash, nonce);
    }

    public ERSArchiveTimeStamp generateArchiveTimeStamp(TimeStampResponse tspResponse) throws TSPException, ERSException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        if (reducedHashTree.length != 1) {
            throw new ERSException("multiple reduced hash trees found");
        }
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        if (tspResponse.getStatus() != 0) {
            throw new TSPException("TSP response error status: " + tspResponse.getStatusString());
        }
        TSTInfo tstInfo = tspResponse.getTimeStampToken().getTimeStampInfo().toASN1Structure();
        if (!tstInfo.getMessageImprint().getHashAlgorithm().equals((Object)this.digCalc.getAlgorithmIdentifier())) {
            throw new ERSException("time stamp imprint for wrong algorithm");
        }
        if (!Arrays.areEqual((byte[])tstInfo.getMessageImprint().getHashedMessage(), (byte[])rootHash)) {
            throw new ERSException("time stamp imprint for wrong root hash");
        }
        if (reducedHashTree[0].getValueCount() == 1) {
            return new ERSArchiveTimeStamp(new ArchiveTimeStamp(null, null, tspResponse.getTimeStampToken().toCMSSignedData().toASN1Structure()), this.digCalc);
        }
        return new ERSArchiveTimeStamp(new ArchiveTimeStamp(this.digCalc.getAlgorithmIdentifier(), reducedHashTree, tspResponse.getTimeStampToken().toCMSSignedData().toASN1Structure()), this.digCalc);
    }

    public List generateArchiveTimeStamps(TimeStampResponse tspResponse) throws TSPException, ERSException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        if (tspResponse.getStatus() != 0) {
            throw new TSPException("TSP response error status: " + tspResponse.getStatusString());
        }
        TSTInfo tstInfo = tspResponse.getTimeStampToken().getTimeStampInfo().toASN1Structure();
        if (!tstInfo.getMessageImprint().getHashAlgorithm().equals((Object)this.digCalc.getAlgorithmIdentifier())) {
            throw new ERSException("time stamp imprint for wrong algorithm");
        }
        if (!Arrays.areEqual((byte[])tstInfo.getMessageImprint().getHashedMessage(), (byte[])rootHash)) {
            throw new ERSException("time stamp imprint for wrong root hash");
        }
        ContentInfo timeStamp = tspResponse.getTimeStampToken().toCMSSignedData().toASN1Structure();
        ArrayList<ERSArchiveTimeStamp> atss = new ArrayList<ERSArchiveTimeStamp>();
        if (reducedHashTree.length == 1 && reducedHashTree[0].getValueCount() == 1) {
            atss.add(new ERSArchiveTimeStamp(new ArchiveTimeStamp(null, null, timeStamp), this.digCalc));
        } else {
            ERSArchiveTimeStamp[] archiveTimeStamps = new ERSArchiveTimeStamp[reducedHashTree.length];
            int i = 0;
            while (i != reducedHashTree.length) {
                PartialHashtree[] path = this.rootNodeCalculator.computePathToRoot(this.digCalc, reducedHashTree[i], i);
                archiveTimeStamps[reducedHashTree[i].order] = new ERSArchiveTimeStamp(new ArchiveTimeStamp(this.digCalc.getAlgorithmIdentifier(), path, timeStamp), this.digCalc);
                ++i;
            }
            int i2 = 0;
            while (i2 != reducedHashTree.length) {
                atss.add(archiveTimeStamps[i2]);
                ++i2;
            }
        }
        return atss;
    }

    private IndexedPartialHashtree[] getPartialHashtrees() {
        List hashes = ERSUtil.buildIndexedHashList(this.digCalc, this.dataObjects, this.previousChainHash);
        IndexedPartialHashtree[] trees = new IndexedPartialHashtree[hashes.size()];
        HashSet<ERSDataGroup> dataGroupSet = new HashSet<ERSDataGroup>();
        int i = 0;
        while (i != this.dataObjects.size()) {
            if (this.dataObjects.get(i) instanceof ERSDataGroup) {
                dataGroupSet.add((ERSDataGroup)this.dataObjects.get(i));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 != hashes.size()) {
            byte[] hash = ((IndexedHash)hashes.get((int)i2)).digest;
            ERSData d = (ERSData)this.dataObjects.get(((IndexedHash)hashes.get((int)i2)).order);
            if (d instanceof ERSDataGroup) {
                ERSDataGroup data = (ERSDataGroup)d;
                List dHashes = data.getHashes(this.digCalc, this.previousChainHash);
                trees[i2] = new IndexedPartialHashtree(((IndexedHash)hashes.get((int)i2)).order, (byte[][])dHashes.toArray((T[])new byte[dHashes.size()][]));
            } else {
                trees[i2] = new IndexedPartialHashtree(((IndexedHash)hashes.get((int)i2)).order, hash);
            }
            ++i2;
        }
        return trees;
    }

    private static class IndexedPartialHashtree
    extends PartialHashtree {
        final int order;

        private IndexedPartialHashtree(int order, byte[] partial) {
            super(partial);
            this.order = order;
        }

        private IndexedPartialHashtree(int order, byte[][] partial) {
            super(partial);
            this.order = order;
        }
    }
}

