/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.tsp.ers.SortedHashList;
import org.bouncycastle.util.Arrays;

public class BinaryTreeRootCalculator
implements ERSRootNodeCalculator {
    private List tree;

    public byte[] computeRootHash(DigestCalculator digCalc, PartialHashtree[] nodes) {
        SortedHashList hashes = new SortedHashList();
        int i = 0;
        while (i < nodes.length) {
            byte[] left = ERSUtil.computeNodeHash(digCalc, nodes[i]);
            hashes.add(left);
            ++i;
        }
        ArrayList<Object> hashValues = hashes.toList();
        this.tree = new ArrayList();
        this.tree.add(hashValues);
        if (hashValues.size() > 1) {
            ArrayList<Object> newHashes;
            do {
                newHashes = new ArrayList<Object>(hashValues.size() / 2 + 1);
                int i2 = 0;
                while (i2 <= hashValues.size() - 2) {
                    newHashes.add(ERSUtil.calculateBranchHash(digCalc, (byte[])hashValues.get(i2), (byte[])hashValues.get(i2 + 1)));
                    i2 += 2;
                }
                if (hashValues.size() % 2 == 1) {
                    newHashes.add(hashValues.get(hashValues.size() - 1));
                }
                this.tree.add(newHashes);
            } while ((hashValues = newHashes).size() > 1);
        }
        return (byte[])hashValues.get(0);
    }

    public PartialHashtree[] computePathToRoot(DigestCalculator digCalc, PartialHashtree node, int index) {
        ArrayList<PartialHashtree> path = new ArrayList<PartialHashtree>();
        byte[] nodeHash = ERSUtil.computeNodeHash(digCalc, node);
        path.add(node);
        int row = 0;
        while (row < this.tree.size() - 1) {
            if (index == ((List)this.tree.get(row)).size() - 1) {
                List hashes;
                while (Arrays.areEqual((byte[])nodeHash, (byte[])((byte[])(hashes = (List)this.tree.get(row + 1)).get(hashes.size() - 1)))) {
                    index = ((List)this.tree.get(++row)).size() - 1;
                }
            }
            byte[] neighborHash = (index & 1) == 0 ? (byte[])((List)this.tree.get(row)).get(index + 1) : (byte[])((List)this.tree.get(row)).get(index - 1);
            path.add(new PartialHashtree(neighborHash));
            nodeHash = ERSUtil.calculateBranchHash(digCalc, nodeHash, neighborHash);
            index /= 2;
            ++row;
        }
        return path.toArray(new PartialHashtree[0]);
    }

    public byte[] recoverRootHash(DigestCalculator digCalc, PartialHashtree[] nodes) {
        byte[] baseHash = ERSUtil.computeNodeHash(digCalc, nodes[0]);
        int i = 1;
        while (i < nodes.length) {
            baseHash = ERSUtil.calculateBranchHash(digCalc, baseHash, ERSUtil.computeNodeHash(digCalc, nodes[i]));
            ++i;
        }
        return baseHash;
    }
}

