/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkix.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

class CrlCache {
    private static final int DEFAULT_TIMEOUT = 15000;
    private static Map cache = Collections.synchronizedMap(new WeakHashMap());

    CrlCache() {
    }

    static synchronized PKIXCRLStore getCrl(CertificateFactory certFact, Date validDate, URL distributionPoint) throws IOException, CRLException {
        PKIXCRLStore crlStore = null;
        WeakReference markerRef = (WeakReference)cache.get(distributionPoint);
        if (markerRef != null) {
            crlStore = (PKIXCRLStore)markerRef.get();
        }
        if (crlStore != null) {
            boolean isExpired = false;
            Iterator it = crlStore.getMatches(null).iterator();
            while (it.hasNext()) {
                X509CRL crl = (X509CRL)it.next();
                Date nextUpdate = crl.getNextUpdate();
                if (nextUpdate == null || !nextUpdate.before(validDate)) continue;
                isExpired = true;
                break;
            }
            if (!isExpired) {
                return crlStore;
            }
        }
        Collection crls = CrlCache.getCrls(certFact, distributionPoint);
        LocalCRLStore localCRLStore = new LocalCRLStore((Store)new CollectionStore(crls));
        cache.put(distributionPoint, new WeakReference<LocalCRLStore>(localCRLStore));
        return localCRLStore;
    }

    private static Collection getCrls(CertificateFactory certFact, URL distributionPoint) throws IOException, CRLException {
        HttpURLConnection crlCon = (HttpURLConnection)distributionPoint.openConnection();
        InputStream crlIn = crlCon.getInputStream();
        Collection<? extends CRL> crls = certFact.generateCRLs(crlIn);
        crlIn.close();
        return crls;
    }

    private static class LocalCRLStore
    implements PKIXCRLStore,
    Iterable {
        private Collection _local;

        public LocalCRLStore(Store collection) {
            this._local = new ArrayList(collection.getMatches(null));
        }

        public Collection getMatches(Selector selector) {
            if (selector == null) {
                return new ArrayList(this._local);
            }
            ArrayList<CRL> col = new ArrayList<CRL>();
            Iterator iter = this._local.iterator();
            while (iter.hasNext()) {
                CRL obj = (CRL)iter.next();
                if (!selector.match((Object)obj)) continue;
                col.add(obj);
            }
            return col;
        }

        public Iterator iterator() {
            return this.getMatches(null).iterator();
        }
    }
}

