/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs.bc;

import java.io.InputStream;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.InputDecryptor;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this((ExtendedDigest)new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) {
                PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance((Object)algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(this, algorithmIdentifier, engine){
                    private final /* synthetic */ AlgorithmIdentifier val$algorithmIdentifier;
                    private final /* synthetic */ PaddedBufferedBlockCipher val$engine;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$algorithmIdentifier = val$algorithmIdentifier;
                        this.val$engine = val$engine;
                    }

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return this.val$algorithmIdentifier;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, (BufferedBlockCipher)this.val$engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(this.val$algorithmIdentifier, PBEParametersGenerator.PKCS12PasswordToBytes((char[])1.access$100(this.this$1)));
                    }
                };
            }

            static /* synthetic */ char[] access$100(1 x0) {
                return x0.password;
            }
        };
    }
}

