/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.jcajce;

import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jcajce.CompositePublicKey;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RawContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.bouncycastle.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.io.TeeOutputStream;

public class JcaContentVerifierProviderBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcaContentVerifierProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentVerifierProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public ContentVerifierProvider build(X509CertificateHolder certHolder) throws OperatorCreationException, CertificateException {
        return this.build(this.helper.convertCertificate(certHolder));
    }

    public ContentVerifierProvider build(final X509Certificate certificate) throws OperatorCreationException {
        JcaX509CertificateHolder certHolder;
        try {
            certHolder = new JcaX509CertificateHolder(certificate);
        }
        catch (CertificateEncodingException e) {
            throw new OperatorCreationException("cannot process certificate: " + e.getMessage(), e);
        }
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return true;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                Signature sig;
                if (algorithm.getAlgorithm().equals((ASN1Primitive)MiscObjectIdentifiers.id_alg_composite)) {
                    return JcaContentVerifierProviderBuilder.this.createCompositeVerifier(algorithm, certificate.getPublicKey());
                }
                try {
                    sig = JcaContentVerifierProviderBuilder.this.helper.createSignature(algorithm);
                    sig.initVerify(certificate.getPublicKey());
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
                Signature rawSig = JcaContentVerifierProviderBuilder.this.createRawSig(algorithm, certificate.getPublicKey());
                if (rawSig != null) {
                    return new RawSigVerifier(algorithm, sig, rawSig);
                }
                return new SigVerifier(algorithm, sig);
            }
        };
    }

    public ContentVerifierProvider build(final PublicKey publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return false;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                if (algorithm.getAlgorithm().equals((ASN1Primitive)MiscObjectIdentifiers.id_alg_composite)) {
                    return JcaContentVerifierProviderBuilder.this.createCompositeVerifier(algorithm, publicKey);
                }
                if (publicKey instanceof CompositePublicKey && ((CompositePublicKey)publicKey).getAlgorithmIdentifier().equals((Object)MiscObjectIdentifiers.id_composite_key)) {
                    List keys = ((CompositePublicKey)publicKey).getPublicKeys();
                    int i = 0;
                    while (i != keys.size()) {
                        try {
                            Signature sig = JcaContentVerifierProviderBuilder.this.createSignature(algorithm, (PublicKey)keys.get(i));
                            Signature rawSig = JcaContentVerifierProviderBuilder.this.createRawSig(algorithm, (PublicKey)keys.get(i));
                            if (rawSig != null) {
                                return new RawSigVerifier(algorithm, sig, rawSig);
                            }
                            return new SigVerifier(algorithm, sig);
                        }
                        catch (OperatorCreationException e) {
                            ++i;
                        }
                    }
                    throw new OperatorCreationException("no matching algorithm found for key");
                }
                Signature sig = JcaContentVerifierProviderBuilder.this.createSignature(algorithm, publicKey);
                Signature rawSig = JcaContentVerifierProviderBuilder.this.createRawSig(algorithm, publicKey);
                if (rawSig != null) {
                    return new RawSigVerifier(algorithm, sig, rawSig);
                }
                return new SigVerifier(algorithm, sig);
            }
        };
    }

    public ContentVerifierProvider build(SubjectPublicKeyInfo publicKey) throws OperatorCreationException {
        return this.build(this.helper.convertPublicKey(publicKey));
    }

    private ContentVerifier createCompositeVerifier(AlgorithmIdentifier compAlgId, PublicKey publicKey) throws OperatorCreationException {
        if (publicKey instanceof CompositePublicKey) {
            List pubKeys = ((CompositePublicKey)publicKey).getPublicKeys();
            ASN1Sequence keySeq = ASN1Sequence.getInstance((Object)compAlgId.getParameters());
            Signature[] sigs = new Signature[keySeq.size()];
            int i = 0;
            while (i != keySeq.size()) {
                AlgorithmIdentifier sigAlg = AlgorithmIdentifier.getInstance((Object)keySeq.getObjectAt(i));
                sigs[i] = pubKeys.get(i) != null ? this.createSignature(sigAlg, (PublicKey)pubKeys.get(i)) : null;
                ++i;
            }
            return new CompositeVerifier(sigs);
        }
        ASN1Sequence keySeq = ASN1Sequence.getInstance((Object)compAlgId.getParameters());
        Signature[] sigs = new Signature[keySeq.size()];
        int i = 0;
        while (i != keySeq.size()) {
            AlgorithmIdentifier sigAlg = AlgorithmIdentifier.getInstance((Object)keySeq.getObjectAt(i));
            try {
                sigs[i] = this.createSignature(sigAlg, publicKey);
            }
            catch (Exception e) {
                sigs[i] = null;
            }
            ++i;
        }
        return new CompositeVerifier(sigs);
    }

    private Signature createSignature(AlgorithmIdentifier algorithm, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature sig = this.helper.createSignature(algorithm);
            sig.initVerify(publicKey);
            return sig;
        }
        catch (GeneralSecurityException e) {
            throw new OperatorCreationException("exception on setup: " + e, e);
        }
    }

    private Signature createRawSig(AlgorithmIdentifier algorithm, PublicKey publicKey) {
        Signature rawSig;
        try {
            rawSig = this.helper.createRawSignature(algorithm);
            if (rawSig != null) {
                rawSig.initVerify(publicKey);
            }
        }
        catch (Exception e) {
            rawSig = null;
        }
        return rawSig;
    }

    private static class CompositeVerifier
    implements ContentVerifier {
        private Signature[] sigs;
        private OutputStream stream;

        public CompositeVerifier(Signature[] sigs) throws OperatorCreationException {
            this.sigs = sigs;
            int start = 0;
            while (start < sigs.length && sigs[start] == null) {
                ++start;
            }
            if (start == sigs.length) {
                throw new OperatorCreationException("no matching signature found in composite");
            }
            this.stream = OutputStreamFactory.createStream((Signature)sigs[start]);
            int i = start + 1;
            while (i != sigs.length) {
                if (sigs[i] != null) {
                    this.stream = new TeeOutputStream(this.stream, OutputStreamFactory.createStream((Signature)sigs[i]));
                }
                ++i;
            }
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(MiscObjectIdentifiers.id_alg_composite);
        }

        public OutputStream getOutputStream() {
            return this.stream;
        }

        public boolean verify(byte[] expected) {
            try {
                ASN1Sequence sigSeq = ASN1Sequence.getInstance((Object)expected);
                boolean failed = false;
                int i = 0;
                while (i != sigSeq.size()) {
                    if (this.sigs[i] != null && !this.sigs[i].verify(ASN1BitString.getInstance((Object)sigSeq.getObjectAt(i)).getOctets())) {
                        failed = true;
                    }
                    ++i;
                }
                return !failed;
            }
            catch (SignatureException e) {
                throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
            }
        }
    }

    private static class RawSigVerifier
    extends SigVerifier
    implements RawContentVerifier {
        private Signature rawSignature;

        RawSigVerifier(AlgorithmIdentifier algorithm, Signature standardSig, Signature rawSignature) {
            super(algorithm, standardSig);
            this.rawSignature = rawSignature;
        }

        public boolean verify(byte[] expected) {
            boolean bl;
            try {
                bl = super.verify(expected);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.rawSignature.verify(expected);
                }
                catch (Exception e) {}
                throw throwable;
            }
            try {
                this.rawSignature.verify(expected);
            }
            catch (Exception e) {
                // empty catch block
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean verify(byte[] digest, byte[] expected) {
            try {
                try {
                    this.rawSignature.update(digest);
                    boolean bl = this.rawSignature.verify(expected);
                    Object var5_5 = null;
                    try {
                        this.rawSignature.verify(expected);
                        return bl;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (SignatureException e) {
                    throw new RuntimeOperatorException("exception obtaining raw signature: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {}
                catch (Exception e) {
                    throw throwable;
                }
                this.rawSignature.verify(expected);
                throw throwable;
            }
        }
    }

    private static class SigVerifier
    implements ContentVerifier {
        private final AlgorithmIdentifier algorithm;
        private final Signature signature;
        protected final OutputStream stream;

        SigVerifier(AlgorithmIdentifier algorithm, Signature signature) {
            this.algorithm = algorithm;
            this.signature = signature;
            this.stream = OutputStreamFactory.createStream((Signature)signature);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        public boolean verify(byte[] expected) {
            try {
                return this.signature.verify(expected);
            }
            catch (SignatureException e) {
                throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
            }
        }
    }
}

