/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.KeyAgreeRecipientId;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class JceKeyAgreeRecipientId
extends KeyAgreeRecipientId {
    public JceKeyAgreeRecipientId(X509Certificate certificate) {
        super(X500Name.getInstance((Object)JceKeyAgreeRecipientId.extractIssuer(certificate)), certificate.getSerialNumber());
    }

    private static X509Principal extractIssuer(X509Certificate certificate) {
        try {
            return PrincipalUtil.getIssuerX509Principal((X509Certificate)certificate);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("can't extract issuer");
        }
    }
}

