/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.ecc.ECCCMSSharedInfo;
import org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.Gost2814789EncryptedKey;
import org.bouncycastle.asn1.cryptopro.Gost2814789KeyWrapParameters;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyAgreeRecipient;
import org.bouncycastle.cms.RecipientOperator;
import org.bouncycastle.cms.jcajce.CMSUtils;
import org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.bouncycastle.cms.jcajce.KeyMaterialGenerator;
import org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import org.bouncycastle.cms.jcajce.RFC5753KeyMaterialGenerator;
import org.bouncycastle.jcajce.spec.GOST28147WrapParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import org.bouncycastle.operator.SecretKeySizeProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public abstract class JceKeyAgreeRecipient
implements KeyAgreeRecipient {
    private static final Set possibleOldMessages = new HashSet();
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    protected EnvelopedDataHelper unwrappingHelper;
    private SecretKeySizeProvider keySizeProvider;
    private AlgorithmIdentifier privKeyAlgID;
    private static KeyMaterialGenerator old_ecc_cms_Generator;
    private static KeyMaterialGenerator simple_ecc_cmsGenerator;
    private static KeyMaterialGenerator ecc_cms_Generator;

    public JceKeyAgreeRecipient(PrivateKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.unwrappingHelper = this.helper;
        this.keySizeProvider = new DefaultSecretKeySizeProvider();
        this.privKeyAlgID = null;
        this.recipientKey = CMSUtils.cleanPrivateKey(recipientKey);
    }

    public JceKeyAgreeRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        this.unwrappingHelper = this.helper;
        return this;
    }

    public JceKeyAgreeRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        this.unwrappingHelper = this.helper;
        return this;
    }

    public JceKeyAgreeRecipient setUnwrappingProvider(Provider provider) {
        this.unwrappingHelper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipient setUnwrappingProvider(String providerName) {
        this.unwrappingHelper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(Provider provider) {
        this.contentHelper = CMSUtils.createContentHelper(provider);
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(String providerName) {
        this.contentHelper = CMSUtils.createContentHelper(providerName);
        return this;
    }

    public JceKeyAgreeRecipient setPrivateKeyAlgorithmIdentifier(AlgorithmIdentifier privKeyAlgID) {
        this.privKeyAlgID = privKeyAlgID;
        return this;
    }

    private SecretKey calculateAgreedWrapKey(AlgorithmIdentifier keyEncAlg, AlgorithmIdentifier wrapAlg, PublicKey senderPublicKey, ASN1OctetString userKeyingMaterial, PrivateKey receiverPrivateKey, KeyMaterialGenerator kmGen) throws CMSException, GeneralSecurityException, IOException {
        receiverPrivateKey = CMSUtils.cleanPrivateKey(receiverPrivateKey);
        if (CMSUtils.isMQV(keyEncAlg.getAlgorithm())) {
            byte[] ukmKeyingMaterial;
            MQVuserKeyingMaterial ukm = MQVuserKeyingMaterial.getInstance((Object)userKeyingMaterial.getOctets());
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(this.getPrivateKeyAlgorithmIdentifier(), ukm.getEphemeralPublicKey().getPublicKeyData());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
            KeyFactory fact = this.helper.createKeyFactory(keyEncAlg.getAlgorithm());
            PublicKey ephemeralKey = fact.generatePublic(pubSpec);
            KeyAgreement agreement = this.helper.createKeyAgreement(keyEncAlg.getAlgorithm());
            byte[] byArray = ukmKeyingMaterial = ukm.getAddedukm() != null ? ukm.getAddedukm().getOctets() : null;
            if (kmGen == old_ecc_cms_Generator) {
                ukmKeyingMaterial = old_ecc_cms_Generator.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), ukmKeyingMaterial);
            }
            agreement.init((Key)receiverPrivateKey, (AlgorithmParameterSpec)new MQVParameterSpec(receiverPrivateKey, ephemeralKey, ukmKeyingMaterial));
            agreement.doPhase(senderPublicKey, true);
            return agreement.generateSecret(wrapAlg.getAlgorithm().getId());
        }
        KeyAgreement agreement = this.helper.createKeyAgreement(keyEncAlg.getAlgorithm());
        UserKeyingMaterialSpec userKeyingMaterialSpec = null;
        if (CMSUtils.isEC(keyEncAlg.getAlgorithm())) {
            byte[] ukmKeyingMaterial = userKeyingMaterial != null ? kmGen.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), userKeyingMaterial.getOctets()) : kmGen.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), null);
            userKeyingMaterialSpec = new UserKeyingMaterialSpec(ukmKeyingMaterial);
        } else if (CMSUtils.isRFC2631(keyEncAlg.getAlgorithm())) {
            if (userKeyingMaterial != null) {
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(userKeyingMaterial.getOctets());
            }
        } else if (CMSUtils.isGOST(keyEncAlg.getAlgorithm())) {
            if (userKeyingMaterial != null) {
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(userKeyingMaterial.getOctets());
            }
        } else {
            throw new CMSException("Unknown key agreement algorithm: " + keyEncAlg.getAlgorithm());
        }
        agreement.init((Key)receiverPrivateKey, (AlgorithmParameterSpec)userKeyingMaterialSpec);
        agreement.doPhase(senderPublicKey, true);
        return agreement.generateSecret(wrapAlg.getAlgorithm().getId());
    }

    protected Key unwrapSessionKey(ASN1ObjectIdentifier wrapAlg, SecretKey agreedKey, ASN1ObjectIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher keyCipher = this.unwrappingHelper.createCipher(wrapAlg);
        keyCipher.init(4, agreedKey);
        return keyCipher.unwrap(encryptedContentEncryptionKey, this.helper.getBaseCipherName(contentEncryptionAlgorithm), 3);
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, SubjectPublicKeyInfo senderKey, ASN1OctetString userKeyingMaterial, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            AlgorithmIdentifier wrapAlg = AlgorithmIdentifier.getInstance((Object)keyEncryptionAlgorithm.getParameters());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(senderKey.getEncoded());
            KeyFactory fact = this.helper.createKeyFactory(senderKey.getAlgorithm().getAlgorithm());
            PublicKey senderPublicKey = fact.generatePublic(pubSpec);
            try {
                SecretKey agreedWrapKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, wrapAlg, senderPublicKey, userKeyingMaterial, this.recipientKey, ecc_cms_Generator);
                if (wrapAlg.getAlgorithm().equals((ASN1Primitive)CryptoProObjectIdentifiers.id_Gost28147_89_None_KeyWrap) || wrapAlg.getAlgorithm().equals((ASN1Primitive)CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap)) {
                    Gost2814789EncryptedKey encKey = Gost2814789EncryptedKey.getInstance((Object)encryptedContentEncryptionKey);
                    Gost2814789KeyWrapParameters wrapParams = Gost2814789KeyWrapParameters.getInstance((Object)wrapAlg.getParameters());
                    Cipher keyCipher = this.helper.createCipher(wrapAlg.getAlgorithm());
                    keyCipher.init(4, (Key)agreedWrapKey, (AlgorithmParameterSpec)new GOST28147WrapParameterSpec(wrapParams.getEncryptionParamSet(), userKeyingMaterial.getOctets()));
                    return keyCipher.unwrap(Arrays.concatenate((byte[])encKey.getEncryptedKey(), (byte[])encKey.getMacKey()), this.helper.getBaseCipherName(contentEncryptionAlgorithm.getAlgorithm()), 3);
                }
                return this.unwrapSessionKey(wrapAlg.getAlgorithm(), agreedWrapKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
            }
            catch (InvalidKeyException e) {
                if (possibleOldMessages.contains(keyEncryptionAlgorithm.getAlgorithm())) {
                    SecretKey agreedWrapKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, wrapAlg, senderPublicKey, userKeyingMaterial, this.recipientKey, old_ecc_cms_Generator);
                    return this.unwrapSessionKey(wrapAlg.getAlgorithm(), agreedWrapKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
                }
                if (userKeyingMaterial != null) {
                    try {
                        SecretKey agreedWrapKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, wrapAlg, senderPublicKey, userKeyingMaterial, this.recipientKey, simple_ecc_cmsGenerator);
                        return this.unwrapSessionKey(wrapAlg.getAlgorithm(), agreedWrapKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
                    }
                    catch (InvalidKeyException ex) {
                        throw e;
                    }
                }
                throw e;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CMSException("originator key spec invalid.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (Exception e) {
            throw new CMSException("originator key invalid.", e);
        }
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithmIdentifier() {
        if (this.privKeyAlgID == null) {
            this.privKeyAlgID = PrivateKeyInfo.getInstance((Object)this.recipientKey.getEncoded()).getPrivateKeyAlgorithm();
        }
        return this.privKeyAlgID;
    }

    public abstract RecipientOperator getRecipientOperator(AlgorithmIdentifier var1, AlgorithmIdentifier var2, SubjectPublicKeyInfo var3, ASN1OctetString var4, byte[] var5) throws CMSException;

    static {
        possibleOldMessages.add(X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme);
        possibleOldMessages.add(X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme);
        old_ecc_cms_Generator = new KeyMaterialGenerator(){

            public byte[] generateKDFMaterial(AlgorithmIdentifier keyAlgorithm, int keySize, byte[] userKeyMaterialParameters) {
                ECCCMSSharedInfo eccInfo = new ECCCMSSharedInfo(new AlgorithmIdentifier(keyAlgorithm.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE), userKeyMaterialParameters, Pack.intToBigEndian((int)keySize));
                try {
                    return eccInfo.getEncoded("DER");
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to create KDF material: " + e);
                }
            }
        };
        simple_ecc_cmsGenerator = new KeyMaterialGenerator(){

            public byte[] generateKDFMaterial(AlgorithmIdentifier keyAlgorithm, int keySize, byte[] userKeyMaterialParameters) {
                return userKeyMaterialParameters;
            }
        };
        ecc_cms_Generator = new RFC5753KeyMaterialGenerator();
    }
}

