/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.KEMRecipientId;
import org.bouncycastle.cms.jcajce.CMSUtils;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class JceKEMRecipientId
extends KEMRecipientId {
    private static X509Principal extractIssuer(X509Certificate certificate) {
        try {
            return PrincipalUtil.getIssuerX509Principal((X509Certificate)certificate);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public JceKEMRecipientId(X509Certificate certificate) {
        super(JceKEMRecipientId.convertPrincipal(JceKEMRecipientId.extractIssuer(certificate)), certificate.getSerialNumber(), CMSUtils.getSubjectKeyId(certificate));
    }

    public JceKEMRecipientId(X509Principal issuer, BigInteger serialNumber) {
        super(JceKEMRecipientId.convertPrincipal(issuer), serialNumber);
    }

    public JceKEMRecipientId(X509Principal issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        super(JceKEMRecipientId.convertPrincipal(issuer), serialNumber, subjectKeyId);
    }

    private static X500Name convertPrincipal(X509Principal issuer) {
        if (issuer == null) {
            return null;
        }
        return X500Name.getInstance((Object)issuer.getEncoded());
    }
}

