/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.jcajce.CMSUtils;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class JcaSignerId
extends SignerId {
    private static X509Principal getPrincipal(X509Certificate cert) {
        try {
            return PrincipalUtil.getIssuerX509Principal((X509Certificate)cert);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to extract principle");
        }
    }

    public JcaSignerId(X509Certificate certificate) {
        super(X500Name.getInstance((Object)JcaSignerId.getPrincipal(certificate).getEncoded()), certificate.getSerialNumber(), CMSUtils.getSubjectKeyId(certificate));
    }
}

