/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();
    private boolean isDefiniteLength = false;

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(DigestAlgorithmIdentifierFinder digestAlgIdFinder) {
        super(digestAlgIdFinder);
    }

    public void setDefiniteLengthEncoding(boolean isDefiniteLength) {
        this.isDefiniteLength = isDefiniteLength;
    }

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        HashSet<AlgorithmIdentifier> digestAlgs = new HashSet<AlgorithmIdentifier>();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        Iterator it = this._signers.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            CMSUtils.addDigestAlgs(digestAlgs, signer, this.digestAlgIdFinder);
            signerInfos.add((ASN1Encodable)signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        Object octs = null;
        if (content.getContent() != null) {
            ByteArrayOutputStream bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), e);
            }
            if (encapsulate) {
                octs = this.isDefiniteLength ? new DEROctetString(bOut.toByteArray()) : new BEROctetString(bOut.toByteArray());
            }
        }
        Iterator it2 = this.signerGens.iterator();
        while (it2.hasNext()) {
            SignerInfoGenerator sGen = (SignerInfoGenerator)it2.next();
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add((ASN1Encodable)inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = CMSSignedDataGenerator.createSetFromList(this.certs, this.isDefiniteLength);
        ASN1Set certrevlist = CMSSignedDataGenerator.createSetFromList(this.crls, this.isDefiniteLength);
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(CMSUtils.convertToDlSet(digestAlgs), encInfo, certificates, certrevlist, (ASN1Set)new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    private static ASN1Set createSetFromList(List list, boolean isDefiniteLength) {
        if (list.size() != 0) {
            return isDefiniteLength ? CMSUtils.createDlSetFromList(list) : CMSUtils.createBerSetFromList(list);
        }
        return null;
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }
}

