/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.operator.OutputAEADEncryptor;

public class CMSAuthEnvelopedDataStreamGenerator
extends CMSAuthEnvelopedGenerator {
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean berEncodeRecipientSet) {
        this._berEncodeRecipientSet = berEncodeRecipientSet;
    }

    private OutputStream doOpen(ASN1ObjectIdentifier dataType, OutputStream out, OutputAEADEncryptor encryptor) throws IOException, CMSException {
        ASN1EncodableVector recipientInfos = CMSUtils.getRecipentInfos(encryptor.getKey(), this.recipientInfoGenerators);
        return this.open(dataType, out, recipientInfos, encryptor);
    }

    protected OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, ASN1EncodableVector recipientInfos, OutputAEADEncryptor encryptor) throws IOException {
        BERSequenceGenerator cGen = new BERSequenceGenerator(out);
        cGen.addObject((ASN1Primitive)CMSObjectIdentifiers.authEnvelopedData);
        BERSequenceGenerator authEnvGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
        authEnvGen.addObject((ASN1Primitive)new ASN1Integer(0L));
        CMSUtils.addOriginatorInfoToGenerator(authEnvGen, this.originatorInfo);
        CMSUtils.addRecipientInfosToGenerator(recipientInfos, authEnvGen, this._berEncodeRecipientSet);
        BERSequenceGenerator eiGen = new BERSequenceGenerator(authEnvGen.getRawOutputStream());
        eiGen.addObject((ASN1Primitive)dataType);
        AlgorithmIdentifier encAlgId = encryptor.getAlgorithmIdentifier();
        eiGen.getRawOutputStream().write(encAlgId.getEncoded());
        OutputStream octetStream = CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, true, this._bufferSize);
        return new CMSAuthEnvelopedDataOutputStream(encryptor, octetStream, cGen, authEnvGen, eiGen);
    }

    protected OutputStream open(OutputStream out, ASN1EncodableVector recipientInfos, OutputAEADEncryptor encryptor) throws CMSException {
        try {
            return this.open(CMSObjectIdentifiers.data, out, recipientInfos, encryptor);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
    }

    public OutputStream open(OutputStream out, OutputAEADEncryptor encryptor) throws CMSException, IOException {
        return this.doOpen(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), out, encryptor);
    }

    private class CMSAuthEnvelopedDataOutputStream
    extends OutputStream {
        private final OutputAEADEncryptor _encryptor;
        private final OutputStream _cOut;
        private final OutputStream _octetStream;
        private final BERSequenceGenerator _cGen;
        private final BERSequenceGenerator _envGen;
        private final BERSequenceGenerator _eiGen;

        public CMSAuthEnvelopedDataOutputStream(OutputAEADEncryptor encryptor, OutputStream octetStream, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this._encryptor = encryptor;
            this._octetStream = octetStream;
            this._cOut = encryptor.getOutputStream(octetStream);
            this._cGen = cGen;
            this._envGen = envGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._cOut.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._cOut.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._cOut.write(bytes);
        }

        public void close() throws IOException {
            ASN1Set authenticatedAttrSet = CMSUtils.processAuthAttrSet(CMSAuthEnvelopedDataStreamGenerator.this.authAttrsGenerator, this._encryptor);
            this._cOut.close();
            this._octetStream.close();
            this._eiGen.close();
            if (authenticatedAttrSet != null) {
                this._envGen.addObject((ASN1Primitive)new DERTaggedObject(false, 1, (ASN1Encodable)authenticatedAttrSet));
            }
            this._envGen.addObject((ASN1Primitive)new DEROctetString(this._encryptor.getMAC()));
            CMSUtils.addAttriSetToGenerator(this._envGen, CMSAuthEnvelopedDataStreamGenerator.this.unauthAttrsGenerator, 2, Collections.EMPTY_MAP);
            this._envGen.close();
            this._cGen.close();
        }
    }
}

