/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.selector.jcajce;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.jce.PrincipalUtil;

public class JcaX509CertificateHolderSelector
extends X509CertificateHolderSelector {
    public JcaX509CertificateHolderSelector(X509Certificate certificate) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(certificate), certificate.getSerialNumber(), JcaX509CertificateHolderSelector.getSubjectKeyId(certificate));
    }

    private static X500Name convertPrincipal(X509Certificate issuer) {
        if (issuer == null) {
            return null;
        }
        try {
            return X500Name.getInstance((Object)PrincipalUtil.getIssuerX509Principal((X509Certificate)issuer).toASN1Primitive());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("conversion failed: " + e.toString());
        }
    }

    private static byte[] getSubjectKeyId(X509Certificate cert) {
        byte[] ext = cert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
        if (ext != null) {
            return ASN1OctetString.getInstance((Object)ASN1OctetString.getInstance((Object)ext).getOctets()).getOctets();
        }
        return null;
    }
}

