/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.crmf.jcajce;

import java.security.Provider;
import java.security.PublicKey;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.jcajce.CRMFHelper;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;

public class JcaCertificateRequestMessage
extends CertificateRequestMessage {
    private CRMFHelper helper = new CRMFHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcaCertificateRequestMessage(CertificateRequestMessage certReqMsg) {
        this(certReqMsg.toASN1Structure());
    }

    public JcaCertificateRequestMessage(CertReqMsg certReqMsg) {
        super(certReqMsg);
    }

    public JcaCertificateRequestMessage setProvider(String providerName) {
        this.helper = new CRMFHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcaCertificateRequestMessage setProvider(Provider provider) {
        this.helper = new CRMFHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public PublicKey getPublicKey() throws CRMFException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.getCertTemplate().getPublicKey();
        if (subjectPublicKeyInfo != null) {
            return this.helper.toPublicKey(subjectPublicKeyInfo);
        }
        return null;
    }
}

