/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.ers.ERSEvidenceRecord;
import org.bouncycastle.tsp.ers.ERSEvidenceRecordSelector;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;

public class ERSEvidenceRecordStore
implements Store {
    private Map recordMap = new HashMap();
    private DigestCalculator digCalc = null;

    public ERSEvidenceRecordStore(Collection collection) throws OperatorCreationException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DigestCalculatorProvider digestCalculatorProvider;
            ERSEvidenceRecord eRSEvidenceRecord = (ERSEvidenceRecord)iterator.next();
            ArchiveTimeStamp archiveTimeStamp = eRSEvidenceRecord.getArchiveTimeStamps()[0];
            if (this.digCalc == null) {
                digestCalculatorProvider = eRSEvidenceRecord.getDigestAlgorithmProvider();
                this.digCalc = digestCalculatorProvider.get(archiveTimeStamp.getDigestAlgorithmIdentifier());
            }
            if ((digestCalculatorProvider = archiveTimeStamp.getHashTreeLeaf()) != null) {
                byte[][] byArray = digestCalculatorProvider.getValues();
                if (byArray.length > 1) {
                    int n = 0;
                    while (n != byArray.length) {
                        this.addRecord(new HashNode(byArray[n]), eRSEvidenceRecord);
                        ++n;
                    }
                    this.addRecord(new HashNode(ERSUtil.computeNodeHash(this.digCalc, (PartialHashtree)digestCalculatorProvider)), eRSEvidenceRecord);
                    continue;
                }
                this.addRecord(new HashNode(byArray[0]), eRSEvidenceRecord);
                continue;
            }
            this.addRecord(new HashNode(archiveTimeStamp.getTimeStampDigestValue()), eRSEvidenceRecord);
        }
    }

    private void addRecord(HashNode hashNode, ERSEvidenceRecord eRSEvidenceRecord) {
        List list = (List)this.recordMap.get(hashNode);
        if (list != null) {
            ArrayList<ERSEvidenceRecord> arrayList = new ArrayList<ERSEvidenceRecord>(list.size() + 1);
            arrayList.addAll(list);
            arrayList.add(eRSEvidenceRecord);
            this.recordMap.put(hashNode, arrayList);
        } else {
            ArrayList<ERSEvidenceRecord> arrayList = new ArrayList<ERSEvidenceRecord>();
            arrayList.add(eRSEvidenceRecord);
            this.recordMap.put(hashNode, arrayList);
        }
    }

    public Collection getMatches(Selector selector) throws StoreException {
        if (selector instanceof ERSEvidenceRecordSelector) {
            HashNode hashNode = new HashNode(((ERSEvidenceRecordSelector)selector).getData().getHash(this.digCalc, null));
            List list = (List)this.recordMap.get(hashNode);
            if (list != null) {
                ArrayList<ERSEvidenceRecord> arrayList = new ArrayList<ERSEvidenceRecord>(list.size());
                int n = 0;
                while (n != list.size()) {
                    ERSEvidenceRecord eRSEvidenceRecord = (ERSEvidenceRecord)list.get(n);
                    if (selector.match((Object)eRSEvidenceRecord)) {
                        arrayList.add(eRSEvidenceRecord);
                    }
                    ++n;
                }
                return Collections.unmodifiableList(arrayList);
            }
            return Collections.unmodifiableList(new ArrayList());
        }
        if (selector == null) {
            HashSet hashSet = new HashSet(this.recordMap.size());
            Iterator iterator = this.recordMap.values().iterator();
            while (iterator.hasNext()) {
                hashSet.addAll((List)iterator.next());
            }
            return Collections.unmodifiableList(new ArrayList(hashSet));
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.recordMap.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            int n = 0;
            while (n != list.size()) {
                if (selector.match(list.get(n))) {
                    hashSet.add(list.get(n));
                }
                ++n;
            }
        }
        return Collections.unmodifiableList(new ArrayList(hashSet));
    }

    private static class HashNode {
        private final byte[] dataHash;
        private final int hashCode;

        public HashNode(byte[] byArray) {
            this.dataHash = byArray;
            this.hashCode = Arrays.hashCode((byte[])byArray);
        }

        public boolean equals(Object object) {
            if (object instanceof HashNode) {
                return Arrays.areEqual((byte[])this.dataHash, (byte[])((HashNode)object).dataHash);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

