/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.ers.ERSCachingData;
import org.bouncycastle.tsp.ers.ERSData;
import org.bouncycastle.tsp.ers.ERSUtil;

public class ERSDataGroup
extends ERSCachingData {
    protected List dataObjects;

    public ERSDataGroup(List list) {
        this.dataObjects = new ArrayList(list.size());
        this.dataObjects.addAll(list);
    }

    public ERSDataGroup(ERSData eRSData) {
        this.dataObjects = new ArrayList();
        this.dataObjects.add(eRSData);
    }

    public ERSDataGroup(ERSData[] eRSDataArray) {
        this.dataObjects = new ArrayList(eRSDataArray.length);
        this.dataObjects.addAll(Arrays.asList(eRSDataArray));
    }

    protected byte[] calculateHash(DigestCalculator digestCalculator, byte[] byArray) {
        List list = this.getHashes(digestCalculator, byArray);
        if (list.size() > 1) {
            ArrayList arrayList = new ArrayList(list.size());
            int n = 0;
            while (n != arrayList.size()) {
                arrayList.add(list.get(n));
                ++n;
            }
            return ERSUtil.calculateDigest(digestCalculator, arrayList.iterator());
        }
        return (byte[])list.get(0);
    }

    public byte[] getHash(DigestCalculator digestCalculator, byte[] byArray) {
        List list = this.getHashes(digestCalculator, byArray);
        if (list.size() > 1) {
            return ERSUtil.calculateDigest(digestCalculator, list.iterator());
        }
        return (byte[])list.get(0);
    }

    public List getHashes(DigestCalculator digestCalculator, byte[] byArray) {
        return ERSUtil.buildHashList(digestCalculator, this.dataObjects, byArray);
    }

    public int size() {
        return this.dataObjects.size();
    }
}

