/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.tsp.TimeStampReq;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPUtil;
import org.bouncycastle.tsp.TSPValidationException;

public class TimeStampRequest {
    private static Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private TimeStampReq req;
    private Extensions extensions;

    public TimeStampRequest(InputStream inputStream) throws IOException {
        this(TimeStampRequest.loadRequest(inputStream));
    }

    public TimeStampRequest(TimeStampReq timeStampReq) {
        this.req = timeStampReq;
        this.extensions = timeStampReq.getExtensions();
    }

    public TimeStampRequest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    private Set convert(Set set) {
        if (set == null) {
            return set;
        }
        HashSet<Object> hashSet = new HashSet<Object>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                hashSet.add(new ASN1ObjectIdentifier((String)e));
                continue;
            }
            hashSet.add(e);
        }
        return hashSet;
    }

    public boolean getCertReq() {
        if (this.req.getCertReq() != null) {
            return this.req.getCertReq().isTrue();
        }
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(this.extensions.getCriticalExtensionOIDs())));
    }

    public byte[] getEncoded() throws IOException {
        return this.req.getEncoded();
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.extensions != null) {
            return this.extensions.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return TSPUtil.getExtensionOIDs(this.extensions);
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    public AlgorithmIdentifier getMessageImprintAlgID() {
        return this.req.getMessageImprint().getHashAlgorithm();
    }

    public ASN1ObjectIdentifier getMessageImprintAlgOID() {
        return this.req.getMessageImprint().getHashAlgorithm().getAlgorithm();
    }

    public byte[] getMessageImprintDigest() {
        return this.req.getMessageImprint().getHashedMessage();
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(this.extensions.getNonCriticalExtensionOIDs())));
    }

    public BigInteger getNonce() {
        if (this.req.getNonce() != null) {
            return this.req.getNonce().getValue();
        }
        return null;
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        if (this.req.getReqPolicy() != null) {
            return this.req.getReqPolicy();
        }
        return null;
    }

    public int getVersion() {
        return this.req.getVersion().intValueExact();
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    private static TimeStampReq loadRequest(InputStream inputStream) throws IOException {
        try {
            return TimeStampReq.getInstance((Object)new ASN1InputStream(inputStream).readObject());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("malformed request: " + classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("malformed request: " + illegalArgumentException);
        }
    }

    public void validate(Set set, Set set2, Set set3) throws TSPException {
        int n;
        set = this.convert(set);
        set2 = this.convert(set2);
        set3 = this.convert(set3);
        if (!set.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm", 128);
        }
        if (set2 != null && this.getReqPolicy() != null && !set2.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy", 256);
        }
        if (this.getExtensions() != null && set3 != null) {
            Enumeration enumeration = this.getExtensions().oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (set3.contains(aSN1ObjectIdentifier)) continue;
                throw new TSPValidationException("request contains unknown extension", 0x800000);
            }
        }
        if ((n = TSPUtil.getDigestLength(this.getMessageImprintAlgOID().getId())) != this.getMessageImprintDigest().length) {
            throw new TSPValidationException("imprint digest the wrong length", 4);
        }
    }
}

