/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.pkcs.DeltaCertificateRequestAttributeValue;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;

public class DeltaCertAttributeUtils {
    public static boolean isDeltaRequestSignatureValid(PKCS10CertificationRequest pKCS10CertificationRequest, ContentVerifierProvider contentVerifierProvider) throws PKCSException {
        Attribute attribute;
        Attribute[] attributeArray = pKCS10CertificationRequest.getAttributes(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.2"));
        DeltaCertificateRequestAttributeValue deltaCertificateRequestAttributeValue = new DeltaCertificateRequestAttributeValue(attributeArray[0]);
        attributeArray = pKCS10CertificationRequest.getAttributes(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.3"));
        CertificationRequest certificationRequest = pKCS10CertificationRequest.toASN1Structure();
        CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertificationRequestInfo();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)certificationRequestInfo.getVersion());
        aSN1EncodableVector.add((ASN1Encodable)certificationRequestInfo.getSubject());
        aSN1EncodableVector.add((ASN1Encodable)certificationRequestInfo.getSubjectPublicKeyInfo());
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Enumeration enumeration = certificationRequestInfo.getAttributes().getObjects();
        while (enumeration.hasMoreElements()) {
            attribute = Attribute.getInstance(enumeration.nextElement());
            if (attribute.getAttrType().equals((ASN1Primitive)new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.3"))) continue;
            aSN1EncodableVector2.add((ASN1Encodable)attribute);
        }
        aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DERSet(aSN1EncodableVector2)));
        attribute = new ASN1EncodableVector();
        attribute.add((ASN1Encodable)new DERSequence(aSN1EncodableVector));
        attribute.add((ASN1Encodable)deltaCertificateRequestAttributeValue.getSignatureAlgorithm());
        attribute.add(attributeArray[0].getAttributeValues()[0]);
        PKCS10CertificationRequest pKCS10CertificationRequest2 = new PKCS10CertificationRequest(CertificationRequest.getInstance((Object)new DERSequence((ASN1EncodableVector)attribute)));
        return pKCS10CertificationRequest2.isSignatureValid(contentVerifierProvider);
    }
}

