/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mozilla.test;

import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.mozilla.PublicKeyAndChallenge;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mozilla.jcajce.JcaSignedPublicKeyAndChallenge;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class SPKACTest
extends SimpleTest {
    byte[] spkac = Base64.decode((String)"MIIBOjCBpDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApne7ti0ibPhV8Iht7Pws5iRckM7x4mtZYxEpeX5/IO8tDsBFdY86ewuY2f2KCca0oMWr43kdkZbPyzf4CSV+0fZm9MJyNMywygZjoOCC+rS8kr0Ef31iHChhYsyejJnjw116Jnn96syhdHY6lVD1rK0nn5ZkHjxU74gjoZu6BJMCAwEAARYAMA0GCSqGSIb3DQEBBAUAA4GBAKFLg/luv0C7gMTI8ZKfFoSyi7Q7kiSQcmSj1WJgT56ouIRJO5NdvB/1n4GNik8VOAU0NRztvGy3ZGqgbSav7lrxcNEvXH+dLbtS97s7yiaozpsOcEHqsBribpLOTRzYa8ciCwkPmIiYqcby11diKLpd+W9RFYNme2v0rrbM2CyV");

    public String getName() {
        return "SignedPubicKeyAndChallenge";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new SPKACTest());
    }

    public void performTest() throws Exception {
        this.spkacTest("spkac", this.spkac);
        this.spkacNewTest("spkac", this.spkac);
    }

    public void spkacNewTest(String string, byte[] byArray) throws Exception {
        byte[] byArray2;
        ASN1IA5String aSN1IA5String;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        JcaSignedPublicKeyAndChallenge jcaSignedPublicKeyAndChallenge = new JcaSignedPublicKeyAndChallenge(byArray);
        PublicKeyAndChallenge publicKeyAndChallenge = jcaSignedPublicKeyAndChallenge.getPublicKeyAndChallenge();
        PublicKey publicKey = jcaSignedPublicKeyAndChallenge.getPublicKey();
        ASN1Primitive aSN1Primitive = publicKeyAndChallenge.toASN1Primitive();
        if (aSN1Primitive == null) {
            this.fail("Error - " + string + " PKAC ASN1Primitive was null.");
        }
        if ((aSN1Primitive = jcaSignedPublicKeyAndChallenge.toASN1Structure().toASN1Primitive()) == null) {
            this.fail("Error - " + string + " SPKAC ASN1Primitive was null.");
        }
        if ((subjectPublicKeyInfo = publicKeyAndChallenge.getSubjectPublicKeyInfo()) == null) {
            this.fail("Error - " + string + " SubjectPublicKeyInfo was null.");
        }
        if ((aSN1IA5String = publicKeyAndChallenge.getChallengeIA5()) == null) {
            this.fail("Error - " + string + " challenge was null.");
        }
        if ((byArray2 = jcaSignedPublicKeyAndChallenge.toASN1Structure().getEncoded("DER")).length != byArray.length) {
            this.fail(String.valueOf(string) + " failed length test");
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray2[n] != byArray[n]) {
                this.fail(String.valueOf(string) + " failed comparison test");
            }
            ++n;
        }
        if (!jcaSignedPublicKeyAndChallenge.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(jcaSignedPublicKeyAndChallenge.getSubjectPublicKeyInfo()))) {
            this.fail(String.valueOf(string) + " verification failed");
        }
        JcaSignedPublicKeyAndChallenge jcaSignedPublicKeyAndChallenge2 = new JcaSignedPublicKeyAndChallenge(byArray);
        if (!jcaSignedPublicKeyAndChallenge.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(jcaSignedPublicKeyAndChallenge2.getPublicKey()))) {
            this.fail(String.valueOf(string) + " verification failed");
        }
    }

    public void spkacTest(String string, byte[] byArray) throws Exception {
        byte[] byArray2;
        ASN1IA5String aSN1IA5String;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        JcaSignedPublicKeyAndChallenge jcaSignedPublicKeyAndChallenge = new JcaSignedPublicKeyAndChallenge(byArray).setProvider("BC");
        PublicKeyAndChallenge publicKeyAndChallenge = jcaSignedPublicKeyAndChallenge.getPublicKeyAndChallenge();
        PublicKey publicKey = jcaSignedPublicKeyAndChallenge.getPublicKey();
        ASN1Primitive aSN1Primitive = publicKeyAndChallenge.toASN1Primitive();
        if (aSN1Primitive == null) {
            this.fail("Error - " + string + " PKAC ASN1Primitive was null.");
        }
        if ((aSN1Primitive = jcaSignedPublicKeyAndChallenge.toASN1Structure().toASN1Primitive()) == null) {
            this.fail("Error - " + string + " SPKAC ASN1Primitive was null.");
        }
        if ((subjectPublicKeyInfo = publicKeyAndChallenge.getSubjectPublicKeyInfo()) == null) {
            this.fail("Error - " + string + " SubjectPublicKeyInfo was null.");
        }
        if ((aSN1IA5String = publicKeyAndChallenge.getChallengeIA5()) == null) {
            this.fail("Error - " + string + " challenge was null.");
        }
        if ((byArray2 = jcaSignedPublicKeyAndChallenge.toASN1Structure().getEncoded("DER")).length != byArray.length) {
            this.fail(String.valueOf(string) + " failed length test");
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray2[n] != byArray[n]) {
                this.fail(String.valueOf(string) + " failed comparison test");
            }
            ++n;
        }
        if (!jcaSignedPublicKeyAndChallenge.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey))) {
            this.fail(String.valueOf(string) + " verification failed");
        }
    }
}

