/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.KEMRecipientId;
import org.bouncycastle.cms.jcajce.CMSUtils;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class JceKEMRecipientId
extends KEMRecipientId {
    public JceKEMRecipientId(X509Certificate x509Certificate) {
        super(JceKEMRecipientId.convertPrincipal(JceKEMRecipientId.extractIssuer(x509Certificate)), x509Certificate.getSerialNumber(), CMSUtils.getSubjectKeyId(x509Certificate));
    }

    public JceKEMRecipientId(X509Principal x509Principal, BigInteger bigInteger) {
        super(JceKEMRecipientId.convertPrincipal(x509Principal), bigInteger);
    }

    public JceKEMRecipientId(X509Principal x509Principal, BigInteger bigInteger, byte[] byArray) {
        super(JceKEMRecipientId.convertPrincipal(x509Principal), bigInteger, byArray);
    }

    private static X500Name convertPrincipal(X509Principal x509Principal) {
        if (x509Principal == null) {
            return null;
        }
        return X500Name.getInstance((Object)x509Principal.getEncoded());
    }

    private static X509Principal extractIssuer(X509Certificate x509Certificate) {
        try {
            return PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }
}

