/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.jcajce.CMSUtils;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class JcaSignerId
extends SignerId {
    public JcaSignerId(X509Certificate x509Certificate) {
        super(X500Name.getInstance((Object)JcaSignerId.getPrincipal(x509Certificate).getEncoded()), x509Certificate.getSerialNumber(), CMSUtils.getSubjectKeyId(x509Certificate));
    }

    private static X509Principal getPrincipal(X509Certificate x509Certificate) {
        try {
            return PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unable to extract principle");
        }
    }
}

