/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map map) {
        Attribute attribute;
        Object object;
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            hashtable.put(object, this.table.get(object));
        }
        if (!hashtable.containsKey(CMSAttributes.contentType)) {
            object = ASN1ObjectIdentifier.getInstance(map.get("contentType"));
            attribute = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(object));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.containsKey(CMSAttributes.messageDigest)) {
            object = (byte[])map.get("digest");
            attribute = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(object)));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.contains(CMSAttributes.cmsAlgorithmProtect)) {
            object = new Attribute(CMSAttributes.cmsAlgorithmProtect, (ASN1Set)new DERSet((ASN1Encodable)new CMSAlgorithmProtection((AlgorithmIdentifier)map.get("digestAlgID"), 2, (AlgorithmIdentifier)map.get("macAlgID"))));
            hashtable.put(object.getAttrType(), object);
        }
        return hashtable;
    }

    public AttributeTable getAttributes(Map map) {
        return new AttributeTable(this.createStandardAttributeTable(map));
    }
}

