/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KEMRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.OtherRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSReadable;
import org.bouncycastle.cms.CMSSecureReadable;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KEMRecipientInformation;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.operator.DigestCalculator;

class CMSEnvelopedHelper {
    CMSEnvelopedHelper() {
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n != aSN1Set.size()) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance((Object)aSN1Set.getObjectAt(n));
            CMSEnvelopedHelper.readRecipientInfo(arrayList, recipientInfo, algorithmIdentifier, cMSSecureReadable);
            ++n;
        }
        return new RecipientInformationStore(arrayList);
    }

    private static void readRecipientInfo(List list, RecipientInfo recipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        ASN1Encodable aSN1Encodable = recipientInfo.getInfo();
        if (aSN1Encodable instanceof KeyTransRecipientInfo) {
            list.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable));
        } else if (aSN1Encodable instanceof OtherRecipientInfo) {
            OtherRecipientInfo otherRecipientInfo = OtherRecipientInfo.getInstance((Object)aSN1Encodable);
            if (CMSObjectIdentifiers.id_ori_kem.equals((ASN1Primitive)otherRecipientInfo.getType())) {
                list.add(new KEMRecipientInformation(KEMRecipientInfo.getInstance((Object)otherRecipientInfo.getValue()), algorithmIdentifier, cMSSecureReadable));
            }
        } else if (aSN1Encodable instanceof KEKRecipientInfo) {
            list.add(new KEKRecipientInformation((KEKRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable));
        } else if (aSN1Encodable instanceof KeyAgreeRecipientInfo) {
            KeyAgreeRecipientInformation.readRecipientInfo(list, (KeyAgreeRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable);
        } else if (aSN1Encodable instanceof PasswordRecipientInfo) {
            list.add(new PasswordRecipientInformation((PasswordRecipientInfo)aSN1Encodable, algorithmIdentifier, cMSSecureReadable));
        }
    }

    static abstract class CMSDefaultSecureReadable
    implements CMSSecureReadable {
        protected final ASN1ObjectIdentifier contentType;
        protected CMSReadable readable;
        protected ASN1Set authAttrSet;

        CMSDefaultSecureReadable(ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSReadable cMSReadable) {
            this.contentType = aSN1ObjectIdentifier;
            this.readable = cMSReadable;
        }

        public ASN1Set getAuthAttrSet() {
            return this.authAttrSet;
        }

        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }

        public abstract InputStream getInputStream() throws IOException, CMSException;

        public abstract boolean hasAdditionalData();

        public void setAuthAttrSet(ASN1Set aSN1Set) {
            this.authAttrSet = aSN1Set;
        }
    }

    static class CMSDigestAuthenticatedSecureReadable
    extends CMSDefaultSecureReadable {
        private DigestCalculator digestCalculator;

        public CMSDigestAuthenticatedSecureReadable(DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSReadable cMSReadable) {
            super(aSN1ObjectIdentifier, cMSReadable);
            this.digestCalculator = digestCalculator;
        }

        static /* synthetic */ DigestCalculator access$0(CMSDigestAuthenticatedSecureReadable cMSDigestAuthenticatedSecureReadable) {
            return cMSDigestAuthenticatedSecureReadable.digestCalculator;
        }

        public byte[] getDigest() {
            return this.digestCalculator.getDigest();
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return new FilterInputStream(this, this.readable.getInputStream()){
                private final /* synthetic */ CMSDigestAuthenticatedSecureReadable this$0;
                {
                    this.this$0 = cMSDigestAuthenticatedSecureReadable;
                }

                public int read() throws IOException {
                    int n = this.in.read();
                    if (n >= 0) {
                        CMSDigestAuthenticatedSecureReadable.access$0(this.this$0).getOutputStream().write(n);
                    }
                    return n;
                }

                public int read(byte[] byArray, int n, int n2) throws IOException {
                    int n3 = this.in.read(byArray, n, n2);
                    if (n3 >= 0) {
                        CMSDigestAuthenticatedSecureReadable.access$0(this.this$0).getOutputStream().write(byArray, n, n3);
                    }
                    return n3;
                }
            };
        }

        public boolean hasAdditionalData() {
            return true;
        }
    }

    static class CMSAuthEnveSecureReadable
    extends CMSDefaultSecureReadable {
        private AlgorithmIdentifier algorithm;

        CMSAuthEnveSecureReadable(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSReadable cMSReadable) {
            super(aSN1ObjectIdentifier, cMSReadable);
            this.algorithm = algorithmIdentifier;
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }

        public boolean hasAdditionalData() {
            return false;
        }
    }
}

