/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcECContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestResult;

public class GOST3410_2012CMSTest
extends SimpleTest {
    public void cmsTest(String string, String string2, String string3, String string4) {
        try {
            boolean bl;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string, "BC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(string2), new SecureRandom());
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            X509CertificateHolder x509CertificateHolder = this.selfSignedCertificate(keyPair, string3);
            byte[] byArray = new byte[]{1, 2, 3, 4, 33, 22, 11, 33, 52, 21, 23};
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(byArray);
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build());
            ContentSigner contentSigner = new JcaContentSignerBuilder(string3).setProvider("BC").build(keyPair.getPrivate());
            SignerInfoGenerator signerInfoGenerator = jcaSignerInfoGeneratorBuilder.build(contentSigner, x509CertificateHolder);
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addCertificate(x509CertificateHolder);
            cMSSignedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, false);
            if (cMSSignedData == null) {
                this.fail("Cant create CMS");
            }
            boolean bl2 = false;
            Iterator iterator = cMSSignedData.getDigestAlgorithmIDs().iterator();
            while (iterator.hasNext()) {
                AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)iterator.next();
                if (!algorithmIdentifier.getAlgorithm().getId().equals(string4)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.fail("identifier not valid");
            }
            if (!(bl = this.verify(cMSSignedData, cMSProcessableByteArray))) {
                this.fail("Verification fails ");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fail("fail with exception:", exception);
        }
    }

    public String getName() {
        return "GOST3410 2012 CMS TEST";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        GOST3410_2012CMSTest gOST3410_2012CMSTest = new GOST3410_2012CMSTest();
        TestResult testResult = gOST3410_2012CMSTest.perform();
        System.out.println(testResult);
    }

    public void performTest() throws Exception {
        if (((Hashtable)Security.getProvider("BC")).containsKey("KeyFactory.ECGOST3410-2012")) {
            this.cmsTest("GOST-3410-2012", "Tc26-Gost-3410-12-512-paramSetA", "GOST3411-2012-512WITHECGOST3410-2012-512", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512.getId());
            this.cmsTest("GOST-3410-2012", "Tc26-Gost-3410-12-512-paramSetB", "GOST3411-2012-512WITHECGOST3410-2012-512", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512.getId());
            this.cmsTest("GOST-3410-2012", "Tc26-Gost-3410-12-512-paramSetC", "GOST3411-2012-512WITHECGOST3410-2012-512", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512.getId());
            this.cmsTest("GOST-3410-2012", "Tc26-Gost-3410-12-256-paramSetA", "GOST3411-2012-256WITHECGOST3410-2012-256", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256.getId());
        }
    }

    private X509CertificateHolder selfSignedCertificate(KeyPair keyPair, String string) throws IOException, OperatorCreationException {
        X500Name x500Name = new X500Name("CN=BB, C=aa");
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        ECParameterSpec eCParameterSpec = eCPublicKey.getParameters();
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCPublicKey.getQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()));
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        ECParameterSpec eCParameterSpec2 = eCPrivateKey.getParameters();
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(eCPrivateKey.getD(), new ECDomainParameters(eCParameterSpec2.getCurve(), eCParameterSpec2.getG(), eCParameterSpec2.getN()));
        ECPublicKeyParameters eCPublicKeyParameters2 = eCPublicKeyParameters;
        ECPrivateKeyParameters eCPrivateKeyParameters2 = eCPrivateKeyParameters;
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(x500Name, BigInteger.ONE, new Date(), new Date(new Date().getTime() + 65520000L), x500Name, SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)eCPublicKeyParameters2));
        DefaultSignatureAlgorithmIdentifierFinder defaultSignatureAlgorithmIdentifierFinder = new DefaultSignatureAlgorithmIdentifierFinder();
        DefaultDigestAlgorithmIdentifierFinder defaultDigestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier algorithmIdentifier = defaultSignatureAlgorithmIdentifierFinder.find(string);
        AlgorithmIdentifier algorithmIdentifier2 = defaultDigestAlgorithmIdentifierFinder.find(algorithmIdentifier);
        BcECContentSignerBuilder bcECContentSignerBuilder = new BcECContentSignerBuilder(algorithmIdentifier, algorithmIdentifier2);
        int n = 2;
        n |= 0x10;
        n |= 0x8000;
        n |= 0x80;
        n |= 1;
        n |= 8;
        n |= 0x20;
        x509v3CertificateBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(n |= 0x40));
        x509v3CertificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        x509v3CertificateBuilder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_timeStamping));
        X509CertificateHolder x509CertificateHolder = x509v3CertificateBuilder.build(bcECContentSignerBuilder.build((AsymmetricKeyParameter)eCPrivateKeyParameters2));
        return x509CertificateHolder;
    }

    private boolean verify(CMSSignedData cMSSignedData, CMSTypedData cMSTypedData) throws CertificateException, OperatorCreationException, IOException, CMSException {
        CMSSignedData cMSSignedData2 = new CMSSignedData((CMSProcessable)cMSTypedData, cMSSignedData.getEncoded());
        Store store = cMSSignedData2.getCertificates();
        SignerInformationStore signerInformationStore = cMSSignedData2.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SignerInformation signerInformation = (SignerInformation)iterator.next();
            SignerId signerId = signerInformation.getSID();
            Collection collection2 = store.getMatches((Selector)signerId);
            Iterator iterator2 = collection2.iterator();
            Object e = iterator2.next();
            SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build((X509CertificateHolder)e);
            boolean bl = signerInformation.verify(signerInformationVerifier);
            if (!bl) continue;
            return true;
        }
        return false;
    }
}

