/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.bc.ExternalValue;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.jcajce.ExternalPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class ExternalKeyTest
extends SimpleTest {
    private void checkCertificate() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        ExternalPublicKey externalPublicKey = new ExternalPublicKey(keyPair.getPublic(), new GeneralName(6, "https://localhost"), MessageDigest.getInstance("SHA256"));
        X500Name x500Name = new X500Name("CN=Test");
        long l = System.currentTimeMillis();
        JcaX509v1CertificateBuilder jcaX509v1CertificateBuilder = new JcaX509v1CertificateBuilder(x500Name, BigIntegers.ONE, new Date(l - 5000L), new Date(l + 50000L), x500Name, (PublicKey)externalPublicKey);
        X509CertificateHolder x509CertificateHolder = jcaX509v1CertificateBuilder.build(new JcaContentSignerBuilder("SHA256withECDSA").build(keyPair.getPrivate()));
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
    }

    private void checkCertificateDilithium() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ML-DSA-87");
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        ExternalPublicKey externalPublicKey = new ExternalPublicKey(keyPair.getPublic(), new GeneralName(6, "https://localhost"), MessageDigest.getInstance("SHA256"));
        X500Name x500Name = new X500Name("C=XX, O=Royal Institute of Public Key Infrastructure, OU=Post-Heffalump Research Department, CN=External Key Test");
        long l = System.currentTimeMillis();
        JcaX509v1CertificateBuilder jcaX509v1CertificateBuilder = new JcaX509v1CertificateBuilder(x500Name, BigInteger.valueOf(System.currentTimeMillis()), new Date(l - 5000L), new Date(l + 157680000000L), x500Name, (PublicKey)externalPublicKey);
        X509CertificateHolder x509CertificateHolder = jcaX509v1CertificateBuilder.build(new JcaContentSignerBuilder("ML-DSA-87").build(keyPair.getPrivate()));
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
    }

    private void checkPublicKeyInfo() throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        byte[] byArray = MessageDigest.getInstance("SHA256").digest(keyPair.getPublic().getEncoded());
        ExternalPublicKey externalPublicKey = new ExternalPublicKey(keyPair.getPublic(), new GeneralName(6, "http://localhost"), MessageDigest.getInstance("SHA256"));
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)externalPublicKey.getEncoded());
        this.isEquals(BCObjectIdentifiers.external_value, subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        ExternalValue externalValue = ExternalValue.getInstance((Object)subjectPublicKeyInfo.parsePublicKey());
        this.isEquals(new GeneralName(6, "http://localhost"), externalValue.getLocation());
        this.isEquals(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), externalValue.getHashAlg());
        this.isTrue(this.areEqual(byArray, externalValue.getHashValue()));
    }

    public String getName() {
        return "ExternalKey";
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new ExternalKeyTest());
        Security.addProvider((Provider)new BouncyCastlePQCProvider());
    }

    public void performTest() throws Exception {
        this.checkPublicKeyInfo();
        this.checkCertificate();
        this.checkCertificateDilithium();
    }
}

