/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.selector.jcajce;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.jce.PrincipalUtil;

public class JcaX509CertificateHolderSelector
extends X509CertificateHolderSelector {
    public JcaX509CertificateHolderSelector(X509Certificate x509Certificate) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(x509Certificate), x509Certificate.getSerialNumber(), JcaX509CertificateHolderSelector.getSubjectKeyId(x509Certificate));
    }

    private static X500Name convertPrincipal(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        try {
            return X500Name.getInstance((Object)PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate).toASN1Primitive());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("conversion failed: " + exception.toString());
        }
    }

    private static byte[] getSubjectKeyId(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue(Extension.subjectKeyIdentifier.getId());
        if (byArray != null) {
            return ASN1OctetString.getInstance((Object)ASN1OctetString.getInstance((Object)byArray).getOctets()).getOctets();
        }
        return null;
    }
}

