/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.ocsp.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class OCSPTestUtil {
    private static final String BC = "BC";
    public static SecureRandom rand;
    public static KeyPairGenerator kpg;
    public static KeyPairGenerator eckpg;
    public static KeyGenerator desede128kg;
    public static KeyGenerator desede192kg;
    public static KeyGenerator rc240kg;
    public static KeyGenerator rc264kg;
    public static KeyGenerator rc2128kg;
    public static BigInteger serialNumber;
    public static final boolean DEBUG = true;

    static {
        try {
            rand = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("RSA", BC);
            kpg.initialize(1024, rand);
            serialNumber = new BigInteger("1");
            eckpg = KeyPairGenerator.getInstance("ECDSA", BC);
            eckpg.initialize(192, rand);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    private static BigInteger allocateSerialNumber() {
        BigInteger bigInteger = serialNumber;
        serialNumber = serialNumber.add(BigInteger.valueOf(1L));
        return bigInteger;
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        return new BcX509ExtensionUtils().createAuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
        return new BcX509ExtensionUtils().createSubjectKeyIdentifier(SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
    }

    public static X509Certificate makeCACertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws Exception {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, true);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string) throws Exception {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair, string, false);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws Exception {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, "SHA1withRSA", false);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, String string3, boolean bl) throws Exception {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair2.getPrivate();
        PublicKey publicKey2 = keyPair2.getPublic();
        JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
        X509v3CertificateBuilder x509v3CertificateBuilder = new JcaX509v3CertificateBuilder(new X500Name(string2), OCSPTestUtil.allocateSerialNumber(), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(string), publicKey).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createSubjectKeyIdentifier(publicKey)).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createAuthorityKeyIdentifier(publicKey2)).addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(bl));
        X509CertificateHolder x509CertificateHolder = x509v3CertificateBuilder.build(new JcaContentSignerBuilder(string3).setProvider(BC).build(privateKey));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(x509CertificateHolder);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, boolean bl) throws Exception {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, "SHA1withRSA", bl);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, X509Certificate x509Certificate, KeyPurposeId keyPurposeId) throws Exception {
        Certificate certificate = Certificate.getInstance((Object)x509Certificate.getEncoded());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(BC).build(keyPair2.getPrivate());
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(certificate.getSubject(), OCSPTestUtil.allocateSerialNumber(), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name(string), keyPair.getPublic());
        JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
        jcaX509v3CertificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createAuthorityKeyIdentifier(x509Certificate));
        jcaX509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        jcaX509v3CertificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        jcaX509v3CertificateBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(keyPurposeId));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(jcaX509v3CertificateBuilder.build(contentSigner));
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, X509Certificate x509Certificate, boolean bl) throws Exception {
        Certificate certificate = Certificate.getInstance((Object)x509Certificate.getEncoded());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(BC).build(keyPair2.getPrivate());
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(certificate.getSubject(), OCSPTestUtil.allocateSerialNumber(), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name(string), keyPair.getPublic());
        JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
        jcaX509v3CertificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createAuthorityKeyIdentifier(x509Certificate));
        jcaX509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        jcaX509v3CertificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(bl));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(jcaX509v3CertificateBuilder.build(contentSigner));
    }

    public static X509Certificate makeCertificateWithOCSP(KeyPair keyPair, String string, KeyPair keyPair2, X509Certificate x509Certificate, boolean bl, String string2) throws Exception {
        Certificate certificate = Certificate.getInstance((Object)x509Certificate.getEncoded());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(BC).build(keyPair2.getPrivate());
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(certificate.getSubject(), OCSPTestUtil.allocateSerialNumber(), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name(string), keyPair.getPublic());
        JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
        jcaX509v3CertificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createAuthorityKeyIdentifier(x509Certificate));
        jcaX509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        jcaX509v3CertificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(bl));
        jcaX509v3CertificateBuilder.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)new AuthorityInformationAccess(new AccessDescription(AccessDescription.id_ad_ocsp, new GeneralName(6, string2))));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(jcaX509v3CertificateBuilder.build(contentSigner));
    }

    public static X509Certificate makeECDSACertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws Exception {
        return OCSPTestUtil.makeECDSACertificate(keyPair, string, keyPair2, string2, false);
    }

    public static X509Certificate makeECDSACertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, boolean bl) throws Exception {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, "SHA1WithECDSA", bl);
    }

    public static KeyPair makeECKeyPair() {
        return ((KeyPairGeneratorSpi)eckpg).generateKeyPair();
    }

    public static KeyPair makeKeyPair() {
        return ((KeyPairGeneratorSpi)kpg).generateKeyPair();
    }

    public static X509Certificate makeRootCertificate(KeyPair keyPair, String string) throws Exception {
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(BC).build(keyPair.getPrivate());
        JcaX509v1CertificateBuilder jcaX509v1CertificateBuilder = new JcaX509v1CertificateBuilder(new X500Name(string), OCSPTestUtil.allocateSerialNumber(), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name(string), keyPair.getPublic());
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(jcaX509v1CertificateBuilder.build(contentSigner));
    }
}

