/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.crmf.jcajce;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.crmf.CertificateRepMessageBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class JcaCertificateRepMessageBuilder
extends CertificateRepMessageBuilder {
    public JcaCertificateRepMessageBuilder(X509Certificate[] x509CertificateArray) throws CertificateEncodingException {
        super(JcaCertificateRepMessageBuilder.convert(x509CertificateArray));
    }

    private static X509CertificateHolder[] convert(X509Certificate[] x509CertificateArray) throws CertificateEncodingException {
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[x509CertificateArray.length];
        int n = 0;
        while (n != x509CertificateHolderArray.length) {
            x509CertificateHolderArray[n] = new JcaX509CertificateHolder(x509CertificateArray[n]);
            ++n;
        }
        return x509CertificateHolderArray;
    }
}

