/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.crmf.bc;

import java.security.SecureRandom;
import org.bouncycastle.cert.crmf.EncryptedValuePadder;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.MGF1BytesGenerator;
import org.bouncycastle.crypto.params.MGFParameters;

public class BcFixedLengthMGF1Padder
implements EncryptedValuePadder {
    private int length;
    private SecureRandom random;
    private Digest dig = new SHA1Digest();

    public BcFixedLengthMGF1Padder(int n) {
        this(n, null);
    }

    public BcFixedLengthMGF1Padder(int n, SecureRandom secureRandom) {
        this.length = n;
        this.random = secureRandom;
    }

    public byte[] getPaddedData(byte[] byArray) {
        byte[] byArray2 = new byte[this.length];
        byte[] byArray3 = new byte[this.dig.getDigestSize()];
        byte[] byArray4 = new byte[this.length - this.dig.getDigestSize()];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray3);
        MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator(this.dig);
        mGF1BytesGenerator.init((DerivationParameters)new MGFParameters(byArray3));
        mGF1BytesGenerator.generateBytes(byArray4, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, byArray3.length, byArray.length);
        int n = byArray3.length + byArray.length + 1;
        while (n != byArray2.length) {
            byArray2[n] = (byte)(1 + this.random.nextInt(255));
            ++n;
        }
        int n2 = 0;
        while (n2 != byArray4.length) {
            int n3 = n2 + byArray3.length;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray4[n2]);
            ++n2;
        }
        return byArray2;
    }

    public byte[] getUnpaddedData(byte[] byArray) {
        byte[] byArray2 = new byte[this.dig.getDigestSize()];
        byte[] byArray3 = new byte[this.length - this.dig.getDigestSize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator(this.dig);
        mGF1BytesGenerator.init((DerivationParameters)new MGFParameters(byArray2));
        mGF1BytesGenerator.generateBytes(byArray3, 0, byArray3.length);
        int n = 0;
        while (n != byArray3.length) {
            int n2 = n + byArray2.length;
            byArray[n2] = (byte)(byArray[n2] ^ byArray3[n]);
            ++n;
        }
        int n3 = 0;
        int n4 = byArray.length - 1;
        while (n4 != byArray2.length) {
            if (byArray[n4] == 0) {
                n3 = n4;
                break;
            }
            --n4;
        }
        if (n3 == 0) {
            throw new IllegalStateException("bad padding in encoding");
        }
        byte[] byArray4 = new byte[n3 - byArray2.length];
        System.arraycopy(byArray, byArray2.length, byArray4, 0, byArray4.length);
        return byArray4;
    }
}

