/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.crmf;

import java.util.ArrayList;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.crmf.CertificateResponse;

public class CertificateRepMessage {
    private final CertResponse[] resps;
    private final CMPCertificate[] caCerts;

    public CertificateRepMessage(CertRepMessage certRepMessage) {
        this.resps = certRepMessage.getResponse();
        this.caCerts = certRepMessage.getCaPubs();
    }

    public static CertificateRepMessage fromPKIBody(PKIBody pKIBody) {
        if (!CertificateRepMessage.isCertificateRepMessage(pKIBody.getType())) {
            throw new IllegalArgumentException("content of PKIBody wrong type: " + pKIBody.getType());
        }
        return new CertificateRepMessage(CertRepMessage.getInstance((Object)pKIBody.getContent()));
    }

    public CMPCertificate[] getCMPCertificates() {
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.caCerts.length];
        System.arraycopy(this.caCerts, 0, cMPCertificateArray, 0, cMPCertificateArray.length);
        return cMPCertificateArray;
    }

    public CertificateResponse[] getResponses() {
        CertificateResponse[] certificateResponseArray = new CertificateResponse[this.resps.length];
        int n = 0;
        while (n != certificateResponseArray.length) {
            certificateResponseArray[n] = new CertificateResponse(this.resps[n]);
            ++n;
        }
        return certificateResponseArray;
    }

    public X509CertificateHolder[] getX509Certificates() {
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>();
        int n = 0;
        while (n != this.caCerts.length) {
            if (this.caCerts[n].isX509v3PKCert()) {
                arrayList.add(new X509CertificateHolder(this.caCerts[n].getX509v3PKCert()));
            }
            ++n;
        }
        return arrayList.toArray(new X509CertificateHolder[0]);
    }

    public static boolean isCertificateRepMessage(int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 8: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean isOnlyX509PKCertificates() {
        boolean bl = true;
        int n = 0;
        while (n != this.caCerts.length) {
            bl &= this.caCerts[n].isX509v3PKCert();
            ++n;
        }
        return bl;
    }

    public CertRepMessage toASN1Structure() {
        return new CertRepMessage(this.caCerts, this.resps);
    }
}

