/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.CMPUtil;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.util.Arrays;

public class ProtectedPKIMessage {
    private PKIMessage pkiMessage;

    ProtectedPKIMessage(PKIMessage pKIMessage) {
        if (pKIMessage.getHeader().getProtectionAlg() == null) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = pKIMessage;
    }

    public ProtectedPKIMessage(GeneralPKIMessage generalPKIMessage) {
        if (!generalPKIMessage.hasProtection()) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = generalPKIMessage.toASN1Structure();
    }

    private DERSequence createProtected() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add((ASN1Encodable)this.pkiMessage.getHeader());
        aSN1EncodableVector.add((ASN1Encodable)this.pkiMessage.getBody());
        return new DERSequence(aSN1EncodableVector);
    }

    public PKIBody getBody() {
        return this.pkiMessage.getBody();
    }

    public X509CertificateHolder[] getCertificates() {
        CMPCertificate[] cMPCertificateArray = this.pkiMessage.getExtraCerts();
        if (cMPCertificateArray == null) {
            return new X509CertificateHolder[0];
        }
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[cMPCertificateArray.length];
        int n = 0;
        while (n != cMPCertificateArray.length) {
            x509CertificateHolderArray[n] = new X509CertificateHolder(cMPCertificateArray[n].getX509v3PKCert());
            ++n;
        }
        return x509CertificateHolderArray;
    }

    public PKIHeader getHeader() {
        return this.pkiMessage.getHeader();
    }

    public AlgorithmIdentifier getProtectionAlgorithm() {
        return this.pkiMessage.getHeader().getProtectionAlg();
    }

    public boolean hasPasswordBasedMacProtection() {
        return CMPObjectIdentifiers.passwordBasedMac.equals((ASN1Primitive)this.getProtectionAlgorithm().getAlgorithm());
    }

    public PKIMessage toASN1Structure() {
        return this.pkiMessage;
    }

    public boolean verify(ContentVerifierProvider contentVerifierProvider) throws CMPException {
        try {
            ContentVerifier contentVerifier = contentVerifierProvider.get(this.getProtectionAlgorithm());
            return this.verifySignature(this.pkiMessage.getProtection().getOctets(), contentVerifier);
        }
        catch (Exception exception) {
            throw new CMPException("unable to verify signature: " + exception.getMessage(), exception);
        }
    }

    public boolean verify(PBEMacCalculatorProvider pBEMacCalculatorProvider, char[] cArray) throws CMPException {
        try {
            MacCalculator macCalculator = pBEMacCalculatorProvider.get(this.getProtectionAlgorithm(), cArray);
            CMPUtil.derEncodeToStream((ASN1Object)this.createProtected(), macCalculator.getOutputStream());
            return Arrays.constantTimeAreEqual((byte[])macCalculator.getMac(), (byte[])this.pkiMessage.getProtection().getOctets());
        }
        catch (Exception exception) {
            throw new CMPException("unable to verify MAC: " + exception.getMessage(), exception);
        }
    }

    private boolean verifySignature(byte[] byArray, ContentVerifier contentVerifier) {
        CMPUtil.derEncodeToStream((ASN1Object)this.createProtected(), contentVerifier.getOutputStream());
        return contentVerifier.verify(byArray);
    }
}

